<?php
class Produkty
{
	const PRODUCTSCATEGORYID = '14';
	const tabela = 'produkty';

	private $_lista = array();
	private $db;
	public $_kategorie = array();

	public $PagesNum = 0;

	public $products;

	public function __construct()
	{
		$this->db = Zend_Registry::get('db');
	}

	public function getIdents($name){
		try
		{
			if(empty($name))
			{
				throw new Exception('#PRODUKTY::PRODUKTY# Brak identyfikatora CELI.');
			}

			$sql = 'select '.$name.' as name from '.Index::dbPrefiks.self::tabela.' where kategoria = 43 GROUP BY '.$name.' ORDER BY '.$name.' ASC';
			return $this->db->fetchAll($sql);
		}

		catch (Zend_Db_Adapter_Exception $e)
		{
			Index::przechwyc_blad($e);
		}

		catch (Zend_Exception $e)
		{
			Index::przechwyc_blad($e);
		}
	}

	public function pagining($items,$page,$limit){
		$pg = 1;
		$fl = 0;
		if(is_array($items)){
			foreach ($items as $key => $i){
				$fl++;
				if($fl > $limit){
					$pg++;
					$fl = 0;
				}
				$products[$pg][] = $i;
			}
			if(isset($products))
			{
				$this->PagesNum = count($products);
				return $products[$page];
			}
		}

		return false;
	}

	public function getProducts($page = 1,$limit = 10){
		return $this->pagining($this->products,$page,$limit);
	}

	public function search_products($cat=0,$search=array()){
		try
		{
			$sql = "
			select p.*,w.nazwa as w_nazwa 
			from ".Index::dbPrefiks.self::tabela." p
			left join ".Index::dbPrefiks."wojewodztwa w on p.wojewodztwo = w.id
			WHERE p.id > 0
			AND aktywny = 'tak'";
			if($cat > 0){
				$sql .= ' AND p.kategoria = '.$cat;
			}

			if(!empty($search['wojewodztwo'])){
				$sql .= " AND wojewodztwo = '".$search['wojewodztwo']."'";
			}

			$sql .= ' ORDER BY id ASC';

			$this->products = $this->db->fetchAll($sql);
		}

		catch (Zend_Db_Adapter_Exception $e)
		{
			Index::przechwyc_blad($e);
		}

		catch (Zend_Exception $e)
		{
			Index::przechwyc_blad($e);
		}
	}

	private function getPromotionsList($id=0)
	{
		try
		{

			//			if(empty($id))
			//			{
			//				throw new Exception('#PRODUKTY::PRODUKTY# Brak identyfikatora pliku.');
			//			}


			if($id!=0)
			$sql = 'select * from '.Index::dbPrefiks.'promotion where kategoria='.(int)$id;
			else
			$sql = 'select * from '.Index::dbPrefiks.'promotion';

			return $this->db->fetchAll($sql);
		}

		catch (Zend_Db_Adapter_Exception $e)
		{
			Index::przechwyc_blad($e);
		}

		catch (Zend_Exception $e)
		{
			Index::przechwyc_blad($e);
		}
	}

	public function getFirstCat($p){

		$parent = $p['kategoria'];

		$fl = 0;

		while($fl == 0){
			$sql = 'select id,parent_id from '.Index::dbPrefiks.'drzewko where id='.(int)$parent;
			$c = $this->db->fetchRow($sql);
			if($c['parent_id'] == 14){
				$fl = 1;
				return $c['id'];
			}
			else {
				$fl = 0;
				$parent = (int)$c['parent_id'];
			}
		}

	}

//	public function getProductId($id)
//	{
//		try
//		{
//			if(empty($id))
//			{
//				throw new Exception('#PRODUKTY::PRODUKTY# Brak identyfikatora pliku.');
//			}
//
//			$sql = "
//			select p.*,w.nazwa as w_nazwa 
//			from ".Index::dbPrefiks.self::tabela." p
//			left join ".Index::dbPrefiks."wojewodztwa w on p.wojewodztwo = w.id
//			where p.id = ".(int)$id."
//			AND aktywny = 'tak'";
//			$product = $this->db->fetchRow($sql);
//
//			$product['zdjecia'] = $this->getPhotos($product['id'],0);
//
//			return $product;
//
//		}
//
//		catch (Zend_Db_Adapter_Exception $e)
//		{
//			Index::przechwyc_blad($e);
//		}
//
//		catch (Zend_Exception $e)
//		{
//			Index::przechwyc_blad($e);
//		}
//	}

	private function getFiles($id){
		$sql = 'select * from '.Index::dbPrefiks.'files where product='.(int)$id;
		return  $this->db->fetchAll($sql);
	}

	public function getProduct2($id){
		try
		{
			if(empty($id))
			{
				throw new Exception('#PRODUKTY::PRODUKTY# Brak identyfikatora pliku.');
			}

			$sql = 'select * from '.Index::dbPrefiks.'products2 where kategoria='.(int)$id;
			return $this->db->fetchAll($sql);

		}

		catch (Zend_Db_Adapter_Exception $e)
		{
			Index::przechwyc_blad($e);
		}

		catch (Zend_Exception $e)
		{
			Index::przechwyc_blad($e);
		}
	}
	
	public function getProductId($id){ 
		try
		{
//			if(empty($id))
//			{
//				throw new Exception('#PRODUKTY::PRODUKTY# Brak identyfikatora pliku.');
//			}

			$sql = 'select *,nazwa_'.$_SESSION['language'].' as nazwa,opis_'.$_SESSION['language'].' as opis,skrot_'.$_SESSION['language'].' as skrot from '.Index::dbPrefiks.'products where id='.(int)$id;
			return $this->db->fetchRow($sql);

		}

		catch (Zend_Db_Adapter_Exception $e)
		{
			Index::przechwyc_blad($e);
		}

		catch (Zend_Exception $e)
		{
			Index::przechwyc_blad($e);
		}
	}

	public function getProduct($id,$wh='kategoria')
	{
		try
		{

			$sql = 'select *,nazwa_'.$_SESSION['language'].' as nazwa,dane_'.$_SESSION['language'].' as opis  from '.Index::dbPrefiks.self::tabela.' where '.$wh.' LIKE "%'.(int)$id.'%" AND `widoczny` = 1';
			
			
			return $this->db->fetchAll($sql);

		}

		catch (Zend_Db_Adapter_Exception $e)
		{
			Index::przechwyc_blad($e);
		}

		catch (Zend_Exception $e)
		{
			Index::przechwyc_blad($e);
		}
	}

	public function getProductsList()
	{
		try
		{
			$sql = 'select p.*, (select nazwa from cms_obrazki where kategoria=p.id and tytulowe=1 LIMIT 1) zdjecie from '.Index::dbPrefiks.self::tabela.' p ';
			//print_r($sql);
			return  $this->db->fetchAll($sql);
		}

		catch (Zend_Db_Adapter_Exception $e)
		{
			Index::przechwyc_blad($e);
		}

		catch (Zend_Exception $e)
		{
			Index::przechwyc_blad($e);
		}
	}
	
	public function getProductsAll($id)
	{
		try
		{
			
			$results = array();
			$list = array();
			
			$sql = 'select id from '.Index::dbPrefiks.'drzewko where id='.$id.' order by kolejnosc';
			$results = $this->db->fetchAll($sql);
			if(!empty($results))
			
			foreach ( $results as $key =>$cc){
				array_push($list,$cc['id']);
				$sql = 'select id from '.Index::dbPrefiks.'drzewko where parent_id='.$results[$key]['id'].' order by kolejnosc';
				$results[$key]['submenu']	=	$this->db->fetchAll($sql);
				if(!empty($results[$key]['submenu'])){
					foreach ($results[$key]['submenu'] as $kkey =>$ccc){
						array_push($list,$ccc['id']);
						$sql = 'select id from '.Index::dbPrefiks.'drzewko where parent_id='.$results[$key]['submenu'][$kkey]['id'].' order by kolejnosc';
						$results[$key]['submenu'][$kkey]['submenu']	=	$this->db->fetchAll($sql);
						foreach($results[$key]['submenu'][$kkey]['submenu'] as $kkkey =>$cccc){
							array_push($list,$cccc['id']);
							$sql = 'select id from '.Index::dbPrefiks.'drzewko where parent_id='.$results[$key]['submenu'][$kkey]['submenu'][$kkkey]['id'].' order by kolejnosc';
							$results[$key]['submenu'][$kkey]['submenu'][$kkkey]['submenu']	=	$this->db->fetchAll($sql);
							foreach($results[$key]['submenu'][$kkey]['submenu'][$kkkey]['submenu'] as $kkkkey =>$ccccc){
								array_push($list,$ccccc['id']);
								
							}
						}
					}
				}
			}
//			echo '<pre>';
//			print_r($results);
//			print_r($list);

			
			
//			if(!empty($id))
			$sql = 'select *,nazwa_'.$_SESSION['language'].' as nazwa,opis_'.$_SESSION['language'].' as opis,skrot_'.$_SESSION['language'].' as skrot  from '.Index::dbPrefiks.self::tabela.' where kategoria = ';
			$i=0;
			foreach($list as $l){
				if($i!=0)
				$sql .= ' OR kategoria = ';
				$sql .= $l;
				$i++;
			}
			

//			echo $sql.'<br />';
//			die();
			
			//print_r($sql);
			return  $this->db->fetchAll($sql);
		}

		catch (Zend_Db_Adapter_Exception $e)
		{
			Index::przechwyc_blad($e);
		}

		catch (Zend_Exception $e)
		{
			Index::przechwyc_blad($e);
		}
	}

	public function getPhotos($id=null,$limit=0)
	{
		try
		{
			if(!empty($id))
			{
				$sql = "select nazwa from cms_obrazki where company=".$id." order by id ASC";
				if($limit > 0){
					$sql .= ' limit '.$limit;
				}
			}
			if($limit == 1)
			$return = $this->db->fetchRow($sql);
			else
			$return = $this->db->fetchAll($sql);
			return $return;

		}

		catch (Zend_Db_Adapter_Exception $e)
		{
			Index::przechwyc_blad($e);
		}

		catch (Zend_Exception $e)
		{
			Index::przechwyc_blad($e);
		}
	}
	
	public function getProducty($cat)
	{
		$db = Zend_Registry::get('db');

		$sql = 'select *,nazwa_'.$_SESSION["language"].' as nazwa,opis_'.$_SESSION["language"].' as opis from '.Index::dbPrefiks.self::tabela.' ORDER BY cw DESC';

		return $db->fetchAll($sql);
	}
	
	public function getAllProdInCat($category)
	{
		$db = Zend_Registry::get('db');

		$sql = 'select *,nazwa_'.$_SESSION["language"].' as nazwa,opis_'.$_SESSION["language"].' as opis from '.Index::dbPrefiks.self::tabela.' WHERE kategoria ='.$category.' AND widoczny = 1';

		return $db->fetchAll($sql);
	}
	
	public function getProdInCat($category)
	{
		$db = Zend_Registry::get('db');

		$sql = 'select *,nazwa_'.$_SESSION["language"].' as nazwa,opis_'.$_SESSION["language"].' as opis from '.Index::dbPrefiks.self::tabela.' WHERE kategoria ='.$category;

		return $db->fetchRow($sql);
	}

    public function getProdPolecamy()
	{
		$db = Zend_Registry::get('db');

		$sql = 'select *,nazwa_'.$_SESSION["language"].' as nazwa,opis_'.$_SESSION["language"].' as opis from '.Index::dbPrefiks.self::tabela.' WHERE polecamy = "TAK" ORDER BY id DESC';

		return $db->fetchRow($sql);
	}

    public function SearchProduct($nazwa)
	{
		$db = Zend_Registry::get('db');
		$what = explode(" ", $nazwa);
		if( !empty($what) )
		{
			for ($i=0;$i<count($what);$i++)
			{
				$sql = "select * from ".Index::dbPrefiks.self::tabela." WHERE nazwa_pl LIKE '%".$what[$i]."%' OR opis_pl LIKE '%".$what[$i]."%'";
			}
			return $db->fetchAll($sql);
		}	
	}

        public function getAllProdukty()
	{
		$db = Zend_Registry::get('db');

		$sql = 'select *, nazwa_pl as nazwa, dane_'.$_SESSION['language'].' as dane from '.Index::dbPrefiks.'produkty WHERE widoczny = 1 ORDER BY kolejnosc ASC';

		return $db->fetchAll($sql);
	}

        public function getAllProduktyOnCategory($cat)
	{
		$db = Zend_Registry::get('db');

		$sql = 'select *,nazwa_'.$_SESSION["language"].' as nazwa from '.Index::dbPrefiks.'produkt WHERE widoczny = 1 AND kategoria = '.$cat.' ORDER BY id ASC';

		return $db->fetchAll($sql);
	}

        public function getProduktOnes($id)
	{
		$db = Zend_Registry::get('db');

		$sql = 'select *,nazwa_'.$_SESSION["language"].' as nazwa, opis_'.$_SESSION["language"].' as opis from '.Index::dbPrefiks.'produkty WHERE widoczny = 1 AND id = '.$id;

		return $db->fetchRow($sql);
	}

        public function getPrAll($id)
	{
		$db = Zend_Registry::get('db');

		$sql = 'select *,nazwa_'.$_SESSION["language"].' as nazwa, opis_'.$_SESSION["language"].' as opis, atrybuty_'.$_SESSION["language"].' as atrybuty from '.Index::dbPrefiks.'produkty WHERE widoczny = 1 AND kategoria = '.$id;

		return $db->fetchAll($sql);
	}

        public function getNEWAll($limit=false)
	{
		$db = Zend_Registry::get('db');

		$sql = 'select *, nazwa_'.$_SESSION["language"].' as nazwa from '.Index::dbPrefiks.'produkty WHERE widoczny = 1 AND nowosc = 1';
		$sql.= ' ORDER BY kolejnosc ASC';
		$sql.= ($limit!==false) ? ' LIMIT '.$limit : '';
		return $db->fetchAll($sql);
	}

        public function getPromo1()
	{
		$db = Zend_Registry::get('db');

		$sql = 'select *,nazwa_'.$_SESSION["language"].' as nazwa,opis_'.$_SESSION["language"].' as opis from '.Index::dbPrefiks.'produkty WHERE widoczny = 1 AND polecamy = "TAK" Limit 2';

		return $db->fetchAll($sql);
	}

        public function getProdsCat($cat)
	{
		$db = Zend_Registry::get('db');

		$sql = 'select *,nazwa_'.$_SESSION["language"].' as nazwa from '.Index::dbPrefiks.'produkty WHERE widoczny = 1 AND kategoria = '.$cat;

		return $db->fetchAll($sql);
	}

        public function getProds($id)
	{
		$db = Zend_Registry::get('db');

		$sql = 'select *,nazwa_'.$_SESSION["language"].' as nazwa, tresc_'.$_SESSION["language"].' as tresc, dane_'.$_SESSION["language"].' as dane from '.Index::dbPrefiks.'produkty WHERE id = '.$id;

		return $db->fetchRow($sql);
	}
        
}
?>
