<?php
session_start();

define ('PREFIKS', 'cms_');
class Index
{
	const dbPrefiks = PREFIKS;

	public function __construct()
	{
		/*
		* bootstrap
		*/

		session_cache_limiter();

		header("Cache-Control: no-store, no-cache, must-revalidate");
		header("Content-Type: text/html; charset=utf-8;");

		//error_reporting(E_ALL);

		date_default_timezone_set('Europe/Warsaw');

		set_include_path('.' . PATH_SEPARATOR . 'cms/library' . PATH_SEPARATOR . get_include_path());
		set_include_path('.' . PATH_SEPARATOR . 'php/modules' . PATH_SEPARATOR . get_include_path());

		include "Zend/Loader.php";
		Zend_Loader::registerAutoload();

		$config = new Zend_Config_Ini ('./cms/config/config.ini', 'glowne');
		$configBaza = new Zend_Config_Ini ('./cms/config/config.ini', 'baza');
		$registry = Zend_Registry::getInstance();


		$db = Zend_Db::factory($configBaza->db->adapter, $configBaza->db->config->toArray());
		Zend_Db_Table::setDefaultAdapter($db);

		$db->query('SET NAMES utf8');
		$db->query('SET CHARACTER SET utf8');

		$registry->set('db', $db);
		$registry->set('config', $config);
		$registry->set('configBaza', $configBaza);

		include_once('Smarty/Smarty.class.php');

		$tpl = new Smarty;
		$tpl->template_dir = './templates/';
		$tpl->compile_dir = './templates_c/';
		//$tpl->debugging = true;

		$tpl->register_modifier('ss', 'stripslashes');
		$tpl->register_modifier('url', 'Index::toPermalink');

		$registry->set('tpl', $tpl);

		$this->getContent();
	}

	public static function przechwyc_blad($e)
	{
		$smarty = Zend_Registry::get('tpl');

		$smarty->assign('nr',$e->getCode());
		$smarty->assign('msg',$e->getMessage());

		echo $e->getMessage();
	}

	function randomString($length){
		static $srand;
		$result = '';
		if($srand != true){
			$srand = true;
			srand((double)microtime()*1000000);
		}
		$chars = "1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
		for($i=0; $i<$length; $i++){
			$result .= substr($chars,rand(0,strlen($chars)-1),1);
		}
		return $result;
	}


	private function authentication($login,$password) {
		$filtr = new Zend_Filter_StripTags();
		$login = $filtr->filter($login);
		$password = md5($filtr->filter($password));
		$db = Zend_Registry::get('db');
		$I = $db->fetchRow("SELECT * FROM ".Index::dbPrefiks."users WHERE nazwa = '$login' AND haslo='$password'");

		if(!empty($I)){
			$_SESSION['user'] = $I;
			return true;
		}
		else {
			return false;
		}
	}

	private function check_mail_syntax($email)
	{
		$to_work_out = explode("@", $email);
		if (!isset($to_work_out[0])) return FALSE;
		if (!isset($to_work_out[1])) return FALSE;

		$pattern_local =  '^([0-9a-z]*([-|_]?[0-9a-z]+)*)(([-|_]?)\.([-|_]?)[0-9a-z]*([-|_]?[0-9a-z]+)+)*([-|_]?)$';
		$pattern_domain = '^([0-9a-z]+([-]?[0-9a-z]+)*)(([-]?)\.([-]?)[0-9a-z]*([-]?[0-9a-z]+)+)*\.[a-z]{2,4}$';
		$match_local = eregi($pattern_local, $to_work_out[0]);
		$match_domain = eregi($pattern_domain, $to_work_out[1]);

		if ($match_local && $match_domain) {
			return TRUE;
		}
		return FALSE;
	}

	private function checkEmpty($string){
		$string = str_replace(' ','',$string);
		$string = strip_tags($string);
		if(strlen($string) > 0)
		return false;
		return true;
	}

	function getSettings(){
		$db = Zend_Registry::get('db');
		$tpl = Zend_Registry::get('tpl');

		return $db->fetchRow("SELECT * FROM ".Index::dbPrefiks."meta WHERE id = 1");

	}
	
	function addModuleMenu($id)
	{
		$db = Zend_Registry::get('db');
		switch($id)
		{
			case 86:	// realizacje - w trakcie 	- infrastruktura kolejowa
			case 87:	// realizacje - w trakcie	- infrastruktura tramwajowa
			case 110:	// realizacje - gotowe		- infrastruktura kolejowa
			case 111:	// realizacje - gotowe		- infrastruktura tramwajowa
       			include_once 'produkty/classProdukty.php';
				$prod 		= new Produkty();
				foreach($prod->getProduct($id) as $produkt)
				{
					$moduleMenu[$produkt['id']] = $produkt;
				}
			break;
			case 99:	// raporty bieżące
				include_once 'files/class.files.php';
				$file 		= new Files();
				$moduleMenu = $db->fetchAll("	SELECT
									YEAR(data) AS url,
									COUNT(id) AS ilosc,
									YEAR(data) AS nazwa
								FROM `".Index::dbPrefiks."files`
								WHERE `widoczny` = '1' AND `kategoria` = '99'
								GROUP BY nazwa
								ORDER BY `data` DESC");
				
			break;
			default: $moduleMenu = FALSE;
		}
		return $moduleMenu;
	}
	
	public function getContent()
	{
		$db = Zend_Registry::get('db');
		$tpl = Zend_Registry::get('tpl');

        if(!isset($_SESSION['language']))
			$_SESSION['language'] = 'pl';
        $tpl->assign('langs',$_SESSION['language']);
		
		$id = 0;
		include_once 'kategorie/classKategorie.php';
		include_once 'tresc/classTresc.php';
		include_once 'files/class.files.php';
		include_once 'newsy/classAktualnosci.php';
		include_once 'gallery/classGalerie.php';
        include_once 'produkty/classProdukty.php';
        include_once 'produkty/classProdukty2.php';
        include_once 'seo/class.seo.php';
        include_once './inc/pagination.class.php';
        include_once 'language.php';
        include_once 'linki/classLinki.php';
        include_once 'pytania/classPytania.php';
		
		$content 	= new Strony();
		$cat		= new Kategorie();
		$news 		= new Aktualnosci();
		$gal 		= new Galerie();
		$file 		= new Files();
		$pg 		= new pagination;
		$seo 		= new Seo();
		$prod 		= new Produkty();
		$oferta		= new Oferta();
		$linki		= new Linki();
		$pytania	= new Pytania();

		$tpl->assign('lang', $text[$_SESSION['language']]);

		$tpl->assign('set', $this->getSettings());
		$tpl->assign('menu', $cat->getMenu(1));
		$tpl->assign('home', FALSE);
		$nav 		= array();
		$moduleMenu = array();
		foreach($_GET as $strona)
			$nav[] = $cat->getCatByURL($strona);
		if(isset($_GET['site']))
		{
			if($_GET['site']=='999')
			{
				switch($_GET['lang']){
			     	case 'en':
			     		$_SESSION['language'] = 'en';
			     	break;
			     	case 'de':
			     		$_SESSION['language'] = 'de';
			     	break;
			     	default:
			      		$_SESSION['language'] = 'pl';
			      	break;
			    }
				$requested_URI=explode('/', $_SERVER['HTTP_REFERER']);
				if(!empty($requested_URI[count($requested_URI)-1]))
				{
					$reguested_file=str_replace('.html', '', $requested_URI[count($requested_URI)-1]);
					$new = explode(',', $reguested_file);
					foreach($new as $k => $strona)
						if(is_numeric($strona))
						{
							$nav[] = $strona;
							//$new[$k]
						}
						else if(!empty($strona))
							$nav[] = $cat->getCatByURL($strona);
				}
				$new=array();
				foreach($nav as $strona)
				{
					if(is_numeric($strona))
						$new[] = $strona;
					else if(!empty($strona) && !is_numeric($strona))
						$new[] = $strona['url'];
				}
                header('Location: '.((!empty($new)) ? implode(',', $new).'.html' : $_SERVER['HTTP_REFERER']));
			}
		}
		$submenu = (isset($nav[0]['id'])) ? $cat->getMenu($nav[0]['id']) : array();
		
		/*
		print("<pre>");
		print_r($_GET);
		print("</pre>");
		*/
		
		if(isset($_GET['id4']))
		{
			$last = $this->addModuleMenu($nav[2]['id']);
			//$nav[3] = $last[$_GET['id4']];
			$nav[2]['submenu'] = $last;
			$nav[3] = $_GET['id4'];
		}
		if(isset($_GET['id3']))
		{
			if(is_numeric($_GET['id3']))
			{
				//$last = $this->addModuleMenu($nav[2]['id']);
				$nav[2] = $_GET['id3'];
			}
		}
		if(!empty($nav))
		{
			if(is_numeric($nav[count($nav)-1]))
			{
				$last = $this->addModuleMenu($nav[count($nav)-1]['id']);
				$nav[count($nav)] = $last[$nav[count($nav)-1]];
			}
		}
		
		//$nav = array_filter($nav, 'strlen');
		$sub = TRUE;
		foreach($submenu as $i => $item)
		{
			if(!empty($item['submenu']))
			{
				foreach($item['submenu'] as $sI => $subItem)
				{
					$sub = $this->addModuleMenu($subItem['id']);
					if($sub) $submenu[$i]['submenu'][$sI]['submenu'] = $this->addModuleMenu($subItem['id']);
				}
			}
			else
			{
				$sub = $this->addModuleMenu($item['id']);
				if($sub) $submenu[$i]['submenu'] = $sub;
			}
		}
		
		
		if(!empty($nav))
		{
			$last_id = FALSE;
			$nav_last_index = count($nav)-1;
			if(is_numeric($nav[$nav_last_index]) && count($nav)>1)
			{
				$category	= $nav[count($nav)-2];
				$last_id 	= TRUE;
			}
			else 
			{
				$category = $nav[$nav_last_index];
			}
			$template_file 	= false;
			$tresc = reset($content->getContentCat($category['id']));
			if(empty($tresc) && !isset($nav[1]))
			{
				header("Location: ".$nav[0]['url'].",".$submenu[0]['url'].".html");
				//$template_file = 'start.tpl';
			}
			else
				$tpl->assign('tresc', $tresc);
			$photo_files	= $gal->getZdjecia($category['id']);
			$pliki			= $file->getFiles($category['id']);
			//$photo_header	= array('pl' => 'Galeria', 'en' => 'Gallery');
			$extras 		= array();
			switch($category['id'])
			{
				case 136:	// mapa
					$template_file = 'map.tpl';
				break;
				case 137:	// kontakt
					if(isset($_SESSION['msg']))
					{
						$tpl->assign('informacja', $_SESSION['msg']);
						unset($_SESSION['msg']);
					}
					if(isset($_SESSION['err']))
					{
						$tpl->assign('informacja', $_SESSION['err']);
					}
					if(isset($_SESSION['dane'])) $tpl->assign('form', $_SESSION['dane']);
					unset($_SESSION['dane']);
					unset($_SESSION['err']);
					unset($_SESSION['ok']);
					$template_file = 'contact.tpl';
				break;
				case 138:	// zapytanie ofertowe
					if(isset($_SESSION['msg']))
					{
						$tpl->assign('informacja', $_SESSION['msg']);
						unset($_SESSION['msg']);
					}
					if(isset($_SESSION['err']))
					{
						$tpl->assign('informacja', $_SESSION['err']);
					}
					if(isset($_SESSION['dane'])) $tpl->assign('form', $_SESSION['dane']);
					unset($_SESSION['dane']);
					unset($_SESSION['err']);
					unset($_SESSION['ok']);
					$template_file = 'inquiryForm.tpl';
				break;
				case 139:
					$subpages = array();
					foreach($cat->getMenu(139) as $subsub)
					{
						$subpages[] = reset($content->getContentCat($subsub['id']));
					}
					$tpl->assign('subpages', $subpages);
				break;
			}
			
			$tpl->assign('extras', $extras);
			
			//$tpl->assign('plik', $plik);
			$tpl->assign('files', $pliki);
			
			$tpl->assign('gallery', $photo_files);
			//$tpl->assign('zdjeciaTytul', $photo_header[$_SESSION['language']]);
			
			//$tpl->assign('zdjeciaPodpis', $gal->getZdjecia($category['id']));
			//$tpl->assign('zdjeciaPodpisTytul', 'Galeria');
			//$tpl->assign('includeSub', $template_file);
		}
		
		$tpl->assign('set', $this->getSettings());
		if(isset($category['id']))
		{
			$seoArray = $seo->getSeo(0,$category['id']); 
			if(is_array($seoArray)){ 
				$tpl->assign('seo',$seoArray); 
			}
		}
		
		$debug = true;
		
		if($debug)
		{
			$debuger = array();
			//var_dump(reset($content->getContentCat(122)));
			$debuger['_get'] = print_r($_GET, TRUE);
			//$debuger['submenu'] = print_r($submenu, TRUE);
			$debuger['nav'] = print_r($nav, TRUE);
			$debuger['category'] = print_r($category, TRUE);
			$debuger['tresc'] = print_r($tresc, TRUE);
			$debuger['photo_files'] = print_r($photo_files, TRUE);
			
			$tpl->assign('debuger', $debuger);
			
		}
		
		$tpl->assign('nav', $nav);
		$tpl->assign('category', $category);
		$tpl->assign('offer', $cat->getMenu(117));
		$tpl->assign('contact', $cat->getMenu(120));
		
		$tpl->assign('box1', reset($content->getContentCat(144)));
		$tpl->assign('box2', reset($content->getContentCat(145)));
		$tpl->assign('box3', reset($content->getContentCat(146)));
		
		if(isset($_GET['id']))
		{
			$tpl->assign('submenu', $submenu);
			$tpl->assign('moduleMenu', $moduleMenu);
			$tpl->assign('include', ($template_file) ? $template_file : 'divided.tpl');
		}
		else 
		{
			$tpl->assign('home', TRUE);
			$tpl->assign('sliderText', reset($content->getContentCat(143)));
			
			//$tpl->assign('popup', ($gal->countImagesInCategory(113)) ? $gal->getFirstImageInCategory(113) : FALSE);
			//$tpl->assign('include', 'start.tpl');
		}
		$tpl->display('index.tpl');
	}
	
	function rss_to_array($tag, $array, $url)
	{
		$doc = new DOMdocument();
        $doc->load($url);
        $rss_array = array();
        $items = array();
        foreach($doc->getElementsByTagName($tag) AS $node)
        {    
        	foreach($array AS $key => $value) 
        	{
        		$items[$value] = $node->getElementsByTagName($value)->item(0)->nodeValue;
            }
            array_push($rss_array, $items);
        }
		return $rss_array;
	}

	public static function toPermalink($string)
	{


		$unPretty = array('/ä/', '/ö/', '/ü/', '/Ä/', '/Ö/', '/Ü/', '/ß/',
		'/ą/', '/Ą/', '/ć/', '/Ć/', '/ę/', '/Ę/', '/ł/', '/Ł/' ,'/ń/', '/Ń/', '/ó/', '/Ó/', '/ś/', '/Ś/', '/ź/', '/Ź/', '/ż/', '/Ż/',
		'/Š/','/Ž/','/š/','/ž/','/Ÿ/','/Ŕ/','/Á/','/Â/','/Ă/','/Ä/','/Ĺ/','/Ç/','/Č/','/É/','/Ę/','/Ë/','/Ě/','/Í/','/Î/','/Ď/','/Ń/',
		'/Ň/','/Ó/','/Ô/','/Ő/','/Ö/','/Ř/','/Ů/','/Ú/','/Ű/','/Ü/','/Ý/','/ŕ/','/á/','/â/','/ă/','/ä/','/ĺ/','/ç/','/č/','/é/','/ę/',
		'/ë/','/ě/','/í/','/î/','/ď/','/ń/','/ň/','/ó/','/ô/','/ő/','/ö/','/ř/','/ů/','/ú/','/ű/','/ü/','/ý/','/˙/',
		'/Ţ/','/ţ/','/Đ/','/đ/','/ß/','/Œ/','/œ/','/Ć/','/ć/','/ľ/');

		$pretty   = array('ae', 'oe', 'ue', 'Ae', 'Oe', 'Ue', 'ss',
		'a', 'A', 'c', 'C', 'e', 'E', 'l', 'L', 'n', 'N', 'o', 'O', 's', 'S', 'z', 'Z', 'z', 'Z',
		'S','Z','s','z','Y','A','A','A','A','A','A','C','E','E','E','E','I','I','I','I','N',
		'O','O','O','O','O','O','U','U','U','U','Y','a','a','a','a','a','a','c','e','e','e',
		'e','i','i','i','i','n','o','o','o','o','o','o','u','u','u','u','y','y',
		'TH','th','DH','dh','ss','OE','oe','AE','ae','u');

		$permalink = strtolower(preg_replace($unPretty, $pretty, $string));
		return  str_replace(" ", "-", preg_replace("/[^a-zA-Z0-9 ]/", "", $permalink) );

	}

	public static function pathToNode($id,$s='1')
	{
		$db = Zend_Registry::get('db');

		if(!empty($id))
		{
			$sql = "SELECT lleft, rright FROM cms_drzewko WHERE id=".(int)$id;
			$results = $db->fetchAll($sql);

			if(!empty($results))
			{
				$sql = "SELECT * FROM cms_drzewko WHERE lleft <=".$results[0]['lleft']." AND rright >=".$results[0]['rright']." ORDER BY id";
				$results = $db->fetchAll($sql);

				$countResults = count($results);

				$path = null;
				$tab = array();

				for($i=0;$i<$countResults;$i++)
				{
					if($results[$i]['id']==1) $path .= '';
					else if($results[$i]['parent_id']==1) $path .= '';

					else $tab[$i]= ucfirst($results[$i]['nazwa']);
				}

				$path = join(' / ',$tab);
			}
		}

		else $path ='';

		return $path;

	}

        public static function usun_ogonki($str)
	{
		$trans = array(
						"Ą" => "a", "ą" => "a", "Ć" => "c", "ć" => "c", "Ę" => "e",
						"ę" => "e", "Ł" => "l", "ł" => "l", "Ó" => "o","ó" => "o",
						"Ń" => "n","ń" => "n","Ś" => "s","ś"=> "s","Ź" => "z",
						"ź"=> "z","Ż" => "z","ż" => "z","," => "");

		return strtr($str, $trans);
	}
	
	function czytaj_katalog($sciezka, $szczegoly)
	{
		$uchwyt = opendir($sciezka);
		while($plik = readdir($uchwyt))
		{
			if($plik!="." && $plik!="..")
			{
				if(is_dir($sciezka."/".$plik))
					$pliki[$plik]=czytaj_katalog($sciezka.'/'.$plik, $szczegoly);
				else
				{
					if($szczegoly)
					{
						$wymiary = getimagesize($sciezka.'/'.$plik);
						$pliki[] = array('nazwa' => $plik, 'szerokosc' => $wymiary[0], 'wysokosc' => $wymiary[1]);
					}
					else 
						$pliki[] = $plik;
				}
			}
		}
		closedir($uchwyt);
		//natsort($pliki);
		return $pliki;
	}
}
?>
