<?php
session_start();

define ('PREFIKS', 'cms_');
class Index
{
	const dbPrefiks = PREFIKS;

	public function __construct()
	{
		/*
		* bootstrap
		*/

		session_cache_limiter("private_no_expire");

		header("Cache-Control: no-store, no-cache, must-revalidate");
		header("Content-Type: text/html; charset=utf-8;");

		error_reporting(E_ALL);

		date_default_timezone_set('Europe/Warsaw');

		set_include_path('.' . PATH_SEPARATOR . 'cms/library' . PATH_SEPARATOR . get_include_path());
		set_include_path('.' . PATH_SEPARATOR . 'php/modules' . PATH_SEPARATOR . get_include_path());

		include "Zend/Loader.php";
		Zend_Loader::registerAutoload();

		$config = new Zend_Config_Ini ('./cms/config/config.ini', 'glowne');
		$configBaza = new Zend_Config_Ini ('./cms/config/config.ini', 'baza');
		$registry = Zend_Registry::getInstance();


		$db = Zend_Db::factory($configBaza->db->adapter, $configBaza->db->config->toArray());
		Zend_Db_Table::setDefaultAdapter($db);

		$db->query('SET NAMES utf8');
		$db->query('SET CHARACTER SET utf8');

		$registry->set('db', $db);
		$registry->set('config', $config);
		$registry->set('configBaza', $configBaza);

		include_once('Smarty/Smarty.class.php');

		$tpl = new Smarty;
		$tpl->template_dir = './templates/';
		$tpl->compile_dir = './templates_c/';

		$tpl->register_modifier('ss', 'stripslashes');
		$tpl->register_modifier('url', 'Index::toPermalink');

		$registry->set('tpl', $tpl);

		$this->getContent();
	}

	public static function przechwyc_blad($e)
	{
		$smarty = Zend_Registry::get('tpl');

		$smarty->assign('nr',$e->getCode());
		$smarty->assign('msg',$e->getMessage());

		echo $e->getMessage();
	}

	function randomString($length){
		static $srand;
		$result = '';
		if($srand != true){
			$srand = true;
			srand((double)microtime()*1000000);
		}
		$chars = "1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
		for($i=0; $i<$length; $i++){
			$result .= substr($chars,rand(0,strlen($chars)-1),1);
		}
		return $result;
	}


	private function authentication($login,$password) {
		$filtr = new Zend_Filter_StripTags();
		$login = $filtr->filter($login);
		$password = md5($filtr->filter($password));
		$db = Zend_Registry::get('db');
		$I = $db->fetchRow("SELECT * FROM ".Index::dbPrefiks."users WHERE nazwa = '$login' AND haslo='$password'");

		if(!empty($I)){
			$_SESSION['user'] = $I;
			return true;
		}
		else {
			return false;
		}
	}

	private function check_mail_syntax($email)
	{
		$to_work_out = explode("@", $email);
		if (!isset($to_work_out[0])) return FALSE;
		if (!isset($to_work_out[1])) return FALSE;

		$pattern_local =  '^([0-9a-z]*([-|_]?[0-9a-z]+)*)(([-|_]?)\.([-|_]?)[0-9a-z]*([-|_]?[0-9a-z]+)+)*([-|_]?)$';
		$pattern_domain = '^([0-9a-z]+([-]?[0-9a-z]+)*)(([-]?)\.([-]?)[0-9a-z]*([-]?[0-9a-z]+)+)*\.[a-z]{2,4}$';
		$match_local = eregi($pattern_local, $to_work_out[0]);
		$match_domain = eregi($pattern_domain, $to_work_out[1]);

		if ($match_local && $match_domain) {
			return TRUE;
		}
		return FALSE;
	}

	private function checkEmpty($string){
		$string = str_replace(' ','',$string);
		$string = strip_tags($string);
		if(strlen($string) > 0)
		return false;
		return true;
	}

	function getSettings(){
		$db = Zend_Registry::get('db');
		$tpl = Zend_Registry::get('tpl');

		return $db->fetchRow("SELECT * FROM ".Index::dbPrefiks."meta WHERE id = 1");

	}
	
	public function getContent()
	{
		$db = Zend_Registry::get('db');
		$tpl = Zend_Registry::get('tpl');

                if(!isset($_SESSION['language'])){
			$_SESSION['language'] = 'pl';
		}

                $tpl->assign('langs',$_SESSION['language']);
		
		$id = 0;
		include_once 'kategorie/classKategorie.php';
		include_once 'tresc/classTresc.php';
		include_once 'files/class.files.php';
		include_once 'newsy/classAktualnosci.php';
		include_once 'gallery/classGalerie.php';
                include_once 'produkty/classProdukty.php';
                include_once 'seo/class.seo.php';
                include_once './inc/pagination.class.php';
                include_once 'language.php';
		
		$content = new Strony();
		$cat = new Kategorie();
		$news = new Aktualnosci();
		$gal = new Galerie();
		$file = new Files();
                $pg = new pagination;
                $seo = new Seo();
                $prod = new Produkty();

                $tpl->assign('lang',$text[$_SESSION['language']]);

		$tpl->assign('set',$this->getSettings());
		$tpl->assign('menu',$cat->getMenu(1));

                if( isset($_SESSION['message']) )
                {
                    $tpl->assign('ok',$_SESSION['message']);
                    unset($_SESSION['message']);
                }
                else
                    $tpl->assign('ok','');

                if( isset($_SESSION['error']) )
                {
                    $tpl->assign('error',$_SESSION['error']);
                    unset($_SESSION['error']);
                }
                else
                    $tpl->assign('error','');

                $quest = $news->getBramka();
                $tpl->assign('quest',$quest);

                $news4 = $news->get4News();
                $tpl->assign('fnews',$news4);

                $baner = $news->getBanery();
                $tpl->assign('banery',$baner);

                $nn = $news->get1News();
                $tpl->assign('nn',$nn);
                
        if( isset($_POST) && !empty($_POST['search']) )
        {
        	$word = $_POST['search'];
        	unset($_POST);
        	header('Location: szukaj,'.$word.'.html');
        }
		
		if(!isset($_GET['site'])){
                        $arts = $news->getArt(1);
                        $tpl->assign('art',$arts);
                        
                $baner1 = $news->getBanery2();
                $tpl->assign('banery2',$baner1);

			$tpl->assign('include','startowa.tpl');
                        $seoArray	=	$seo->getSeo(0,2);

			if(is_array($seoArray)){
				$tpl->assign('seo',$seoArray);
			}

		}

		if(isset($_POST['send'])){
			$tpl->assign('send_result',$this->send_question());
		}

                if( !isset($k) )
                {
                    $ka = 1;
                    $tpl->assign('ka',$ka);
                }

		if(isset($_GET['site'])){
			if(isset($_GET['id']))
			$id 			=	(int)$_GET['id'];
			if(isset($_GET['site']))
			$strona 		=	(int)$_GET['site'];
			if(isset($_GET['page']))
			$page 		=	(int)$_GET['page'];
			if(isset($_GET['it']))
			$it			=	(int)$_GET['it'];
                        if(isset($_GET['m']))
			$m			=	(int)$_GET['m'];
                        if(isset($_GET['y']))
			$y			=	(int)$_GET['y'];
			if(isset($_GET['q']))
			$q			= addslashes ($_GET['q']);
			
			if(!empty($id))
			$path = $cat->getPath($id);
			else
			$path = $cat->getPath($strona);
			sort($path);
			$tpl->assign('path',$path);

                        $seoArray	=	$seo->getSeo(0,$strona);
//
			if(is_array($seoArray)){
				$tpl->assign('seo',$seoArray);
			}
			
			switch($strona){
				case 1:
					$words = $q;
					$szukaj = $news->szukajW($words);
					//print_r($szukaj);
					$catss['nazwa'] = "Szukaj";
					$tpl->assign('cat',$catss);
					$tpl->assign('wynik',$szukaj);
					$tpl->assign('fraza',$words);
					$tpl->assign('include','szukaj.tpl');
					break;
                            case 2:
                                $cat_name = $cat->getCat($strona);
                                $tpl->assign('cat',$cat_name);

                                if( empty($id))
                                {
                                    $txt = $news->getWpis($strona);
                                    $tpl->assign('art',$txt);

                                    $tpl->assign('include','kri.tpl');
                                }
                                else
                                {
//                                    print($id);
                                    if( $id != 10 && $id != 22 )
                                    {
                                        $txt = $news->getWpis($id);
                                        $tpl->assign('art',$txt);

                                        $cat_name2 = $cat->getCat($id);
                                        $tpl->assign('cat2',$cat_name2);

                                        $tpl->assign('include','kri.tpl');
                                    }
                                    else if($id == 10)
                                    {
                                        $cat_name2 = $cat->getCat($id);
                                        $tpl->assign('cat2',$cat_name2);

                                        $zarz = $news->getZarzad();
                                        $tpl->assign('zarz',$zarz);

                                        $txt = $news->getWpis($id);
                                        $tpl->assign('art',$txt);
                                        
                                        $tpl->assign('include','kri2.tpl');
                                    }
                                    else if( $id == 22 )
                                    {
//                                        print($id);
                                        $cat_name2 = $cat->getCat($id);
                                        $tpl->assign('cat2',$cat_name2);

                                        $zarz = $news->getRada();
                                        $tpl->assign('zarz',$zarz);

                                        $txt = $news->getWpis($id);
                                        $tpl->assign('art',$txt);

                                        $tpl->assign('include','kri2.tpl');
                                    }
                                }                                
                                break;
                            case 3:
                                $cat_name = $cat->getCat($strona);
                                $tpl->assign('cat',$cat_name);
                                if( empty($id))
                                {
                                    $txt = $news->getWpis($strona);
                                    $tpl->assign('art',$txt);
                                $tpl->assign('include','oferta.tpl');
                                }
                                else
                                {
                                    $cat_name2 = $cat->getCat($id);
                                    $tpl->assign('cat2',$cat_name2);
                                    //if($id != 27)
                                   // {
                                		$txt = $news->getWpis($id);
                                		$tpl->assign('art',$txt);
                                		$tpl->assign('include','oferta.tpl');
                                    /*}
                                    else if($id == 27)
                                    {
                                    	$subs = $cat->getMenu($id);
                                    	$tpl->assign('subs',$subs);
                                    	$fils = $file->getAllFiles();
                                    	$tpl->assign('files',$fils);
                                		$tpl->assign('include','oferta2.tpl');
                                    }*/
                                }
                                break;
                            case 4:
                                $cat_name = $cat->getCat($strona);
                                $tpl->assign('cat',$cat_name);
                                if( empty($id))
                                {
                                    $txt = $news->getWpis($strona);
                                    $tpl->assign('art',$txt);
                                    $tpl->assign('include','relacje.tpl');
                                }
                                else
                                {
                                    if( $id != 11 && $id != 47)
                                    {
                                        $cat_name2 = $cat->getCat($id);
                                        $tpl->assign('cat2',$cat_name2);
                                        $txt = $news->getWpis($id);
                                        $tpl->assign('art',$txt);
                                        $tpl->assign('include','relacje.tpl');
                                    }
                                    else if($id == 11)
                                    {
                                        $cat_name2 = $cat->getCat($id);
                                        $tpl->assign('cat2',$cat_name2);
                                        if( !empty($y) && empty($m))
                                        {
                                        	$this_year = $y;
                                            $this_month = date('m');
                                            $ty1 = date('Y');
                                            $all_year = $news->getRaportByYear();
                                            $count_year = count($all_year);
                                            $dane = array();
                                            for($i=0;$i<$count_year;$i++)
                                            {
                                            	for($j=1;$j<13;$j++)
                                            	{
                                                	$dane[$i][$all_year[$i]['y']][$j] = count($news->getRaportByMonth($all_year[$i]['y'],$j));
                                                }
                                            }
                                            $raport = $news->getRaporty2($y);
                                            $tpl->assign('dane',$dane);
                                            $tpl->assign('raporty',$raport);
                                            $tpl->assign('years',$all_year);
                                            $tpl->assign('yearA',$this_year);
                                            if( $ty1 == "2012" ){
                                               	$qwe = $ty1 - $y-1;
                                              	$tpl->assign('yA',$qwe);
                                            } 
                                        }
                                        else if( !empty($y) && !empty($m) )
                                        {
                                            $all_year = $news->getRaportByYear();
                                            $count_year = count($all_year);
                                            $ty1 = date('Y');
                                            $dane = array();
                                            for($i=0;$i<$count_year;$i++)
                                            {
                                                for($j=1;$j<13;$j++)
                                                {
                                                    $dane[$i][$all_year[$i]['y']][$j] = count($news->getRaportByMonth($all_year[$i]['y'],$j));
                                                }
                                            }
                                            $raport = $news->getRaportByMonth($y, $m);
                                            
                                            $tpl->assign('dane',$dane);
                                            $tpl->assign('raporty',$raport);
                                            $tpl->assign('years',$all_year);
                                            $tpl->assign('yearA',$y);
                                            //$tpl->assign('yearA',$this_year);
                                            if( $ty1 == "2012" ){
                                               	$qwe = $ty1 - $y-1;
                                              	$tpl->assign('yA',$qwe);
                                            } 
                                        }
                                        else
                                        {
                                            if( empty($q))
                                            {
                                                $this_year = date('Y');
                                                $ty1 = date('Y');
                                                $this_month = date('m');
                                                $all_year = $news->getRaportByYear();
                                                $count_year = count($all_year);
                                                $dane = array();
                                                
                                                for($i=0;$i<$count_year;$i++)
                                                {
                                                    for($j=1;$j<13;$j++)
                                                    {
                                                        $dane[$i][$all_year[$i]['y']][$j] = count($news->getRaportByMonth($all_year[$i]['y'],$j));
                                                    }
                                                }
                                                $raport = $news->getRaportByMonth($this_year, $this_month);
	                                            if( empty($raport) )
	                                            {
	                                            	for($l=0;$l<$this_month;$l++)
	                                            	{
		                                            	if($this_month == '01') $this_month = '12';
		                                            	if($this_month > '01') $this_month = $this_month - 1;
		                                            	$raport2 = $news->getRaportByMonth($this_year, $this_month);
		                                            	if( !empty($raport2) )
		                                            	{
		                                            		$raport = $raport2;
		                                            		break;
		                                            	}
	                                            	}
	                                            }
	                                            if( empty($raport) )
	                                            {
	                                            	for($k=12;$k>0;$k--)
	                                            	{
	                                            		$this_year = $this_year - 1;
	                                            		$raport3 = $news->getRaportByMonth($this_year, $k);
	                                            		if( !empty($raport3) )
		                                            	{
		                                            		$raport = $raport3;
		                                            		break;
		                                            	}
	                                            	}
	                                            }
                                                $tpl->assign('dane',$dane);
                                                //print_r($dane[0]);
                                                //print($dane[$this_year]);
                                                $tpl->assign('raporty',$raport);
                                                $tpl->assign('years',$all_year);
                                                //print_r($all_year);
                                                $tpl->assign('yearA',$this_year);
                                                //print($this_year);
                                                if( $ty1 == "2012" ){
                                                	$qwe = $ty1 - $this_year-1;
                                                	$tpl->assign('yA',$qwe);
                                                } 
                                            }
                                            else
                                            {
                                                $this_year = date('Y');
                                                $this_month = date('m');
                                                $all_year = $news->getRaportByYear();
                                                $count_year = count($all_year);
                                                $dane = array();
                                                for($i=0;$i<$count_year;$i++)
                                                {
                                                    for($j=1;$j<13;$j++)
                                                    {
                                                        $dane[$i][$all_year[$i]['y']][$j] = count($news->getRaportByMonth($all_year[$i]['y'],$j));
                                                    }
                                                }
                                                $raport = $news->getRaporty();
                                                $tpl->assign('dane',$dane);
                                                $tpl->assign('raporty',$raport);
                                                $tpl->assign('years',$all_year);
                                                $tpl->assign('yearA',$this_year);
                                            }
                                        }
                                        $tpl->assign('include','relacje2.tpl');
                                    }
                                    /*else if( $id == 45)
                                    {
                                        $cat_name2 = $cat->getCat($id);
                                        $tpl->assign('cat2',$cat_name2);

                                        $fils = $file->getFiles($id);
                                        $tpl->assign('files',$fils);

                                        $tpl->assign('include','prezentacje.tpl');
                                    }*/
                                    /*else if( $id == 44)
                                    {
                                        $cat_name2 = $cat->getCat($id);
                                        $tpl->assign('cat2',$cat_name2);
                                        $py = $news->getCalByYear();
                                        $tpl->assign('c_year',$py);

                                        if(empty($y))
                                        {
                                            $ty = date('Y');
                                            $kom = $news->getCalAllbyYear($ty);
                                            if( empty($kom))
                                            {
                                            	$ty2 = $ty - 1;
                                            	$kom = $news->getCalAllbyYear($ty2);
                                            	if( empty($kom) )
                                            	{
                                            		$ty3 = $ty - 2;
                                            		$kom = $news->getCalAllbyYear($ty3);
                                            	} 
                                            }
                                        }
                                        else
                                        {
                                            if( $y != 1)
                                                $kom = $news->getCalAllbyYear($y);
                                            else
                                                $kom = $news->getCalAll();
                                        }
//                                        $kom = $news->getKomunikatyAll();
                                        $tpl->assign('cal',$kom);

                                        $tpl->assign('include','cal.tpl');
                                    }*/
                                	else if( $id == 47)
                                    {
                                        $cat_name2 = $cat->getCat($id);
                                        $tpl->assign('cat2',$cat_name2);

                                        $tpl->assign('include','notowania.tpl');
                                    }
                                }
                                break;
                            case 5:
                                //centrum prasowe
                                $cat_name = $cat->getCat($strona);
                                $tpl->assign('cat',$cat_name);
                                if( empty($id))
                                {
                                    $txt = $news->getWpis($strona);
                                    $tpl->assign('art',$txt);
                                    $tpl->assign('include','press.tpl');
                                }
                                else
                                {
                                    if( $id != 12 && $id != 39)
                                    {
                                        $cat_name2 = $cat->getCat($id);
                                        $tpl->assign('cat2',$cat_name2);
                                        $txt = $news->getWpis($id);
                                        $tpl->assign('art',$txt);
                                        $tpl->assign('include','press.tpl');
                                    }
                                    else if($id == 12)
                                    {
                                        $cat_name2 = $cat->getCat($id);
                                        $tpl->assign('cat2',$cat_name2);
                                        $py = $news->getKomunikatByYear();
                                        $tpl->assign('p_year',$py);

                                        if(empty($y))
                                        {
                                        	//print('ad');
                                            $ty = date('Y');
                                            $kom = $news->getKomunikatyAllbyYear($ty);
                                            if( empty($kom) )
                                            {
                                            	$ty2 = $ty - 1;
                                            	//print($ty2);
                                            	$kom = $news->getKomunikatyAllbyYear($ty2);
                                            }
                                        }
                                        else
                                        {
                                            $kom = $news->getKomunikatyAllbyYear($y);
                                        }
//                                        $kom = $news->getKomunikatyAll();
                                        $tpl->assign('kom',$kom);

                                        $tpl->assign('include','press2.tpl');
                                    }
                                    else if( $id == 39)
                                    {
                                        $cat_name2 = $cat->getCat($id);
                                        $tpl->assign('cat2',$cat_name2);

                                        $g_menu = $cat->getMenu(39);
                                        $tpl->assign('g_menu',$g_menu);

                                        $foto = $gal->getAllZdjecia();
                                        $tpl->assign('foto',$foto);

                                        $tpl->assign('include','galeria.tpl');
                                    }
                                }          
                                break;
                            case 7:
                                $cat_name = $cat->getCat($strona);
                                $tpl->assign('cat',$cat_name);

                                if( empty($id))
                                    $txt = $news->getWpis($strona);
                                else
                                    $txt = $news->getWpis($id);
                                $tpl->assign('art',$txt);

                                $tpl->assign('include','kontakt.tpl');
                                break;
                            case 16:
                                $cat_name = $cat->getCat($strona);
                                $tpl->assign('cat',$cat_name);

                                //$newsy = $news->getAllNews();
                                //$tpl->assign('newsy',$newsy);
                                
                                $cat_name2 = $cat->getCat($id);
                                $tpl->assign('cat2',$cat_name2);
                                $py = $news->getNewsByYear();
                                //print_r($py);
                                $tpl->assign('n_year',$py);

                                if(empty($y))
                                {
                                	$ty = date('Y');
                                	$kom = $news->getNewsAllbyYear($ty);
                                	if( empty($kom) ){
                                		$ty2 = $ty - 1;
                                		$kom = $news->getNewsAllbyYear($ty2);
                                	}
                                }
                                else
                                {
                                	if( $y != 1)
                                		$kom = $news->getNewsAllbyYear($y);
                                	else
                                    	$kom = $news->getNewsAll();
                                }
//                              $kom = $news->getKomunikatyAll();
                                $tpl->assign('newsy',$kom);

                                $tpl->assign('include','news.tpl');
                                break;
                                /*
                            case 13:
                                    $sub = $cat->getMenu($strona);
                                    $tpl->assign('sub',$sub);

                                    if( empty($id) )
                                    {
                                        $arts = $news->getWpis($strona);
                                    }
                                    else
                                    {
                                        $arts = $news->getWpis($id);
                                    }

                                    $tpl->assign('art',$arts);
                                    $tpl->assign('include','tekstowa.tpl');
                            break;
                            case 12:
//                                print_r($_SESSION);
                                $sub2 = $cat->getMenu(5);
                                    $tpl->assign('sub2',$sub2);
                                $kom = $news->getKomunikat();
                                $tpl->assign('kom',$kom);

                                if(isset($_POST['access']) && $_POST['access'] == '1'){
                                        $_SESSION['access'] = 1;
                                }

                                $tpl->assign('include','press.tpl');
                                break;
                            case 11:
                                    $sub2 = $cat->getMenu(4);
                                    $tpl->assign('sub2',$sub2);

                                    if( empty($m) && empty($y) )
                                        {
                                            $news_all = $news->getAllNews();
                                            $this_year = date('Y');
                                            $this_month = date('m');
                                            $all_year = $news->getCountNewsByYear();
                                            $count_year = count($all_year);
                                            $ar = array();
                                            $mon = array('1','2','3','4','5','6','7','8','9','10','11','12');
                                            $tpl->assign('mon',$mon);
                                            for($i=0;$i<$count_year;$i++)
                                            {
                                                for($j=1;$j<13;$j++)
                                                {
                                                    $ar[$i][$all_year[$i]['y']][$j] = count($news->getCountNewsByMonth($all_year[$i]['y'],$j));
                                                }
                                            }
//                                            print_r($ar);
                                            $newsy = $news->getCountNewsByMonth($this_year,$this_month);
                                            $tpl->assign('news',$newsy);

                                            $tpl->assign('ar',$ar);

                                            $tpl->assign('year',$all_year);
                                        }
                                        else{
                                                $news_all = $news->getAllNews();
                                                $this_year = date('Y');
                                                $this_month = date('m');
                                                $all_year = $news->getCountNewsByYear();
                                                $count_year = count($all_year);
                                                $ar = array();
                                                $mon = array('1','2','3','4','5','6','7','8','9','10','11','12');
                                                $tpl->assign('mon',$mon);
                                                for($i=0;$i<$count_year;$i++)
                                                {
                                                    for($j=1;$j<13;$j++)
                                                    {
                                                        $ar[$i][$all_year[$i]['y']][$j] = count($news->getCountNewsByMonth($all_year[$i]['y'],$j));
                                                    }
                                                }

                                                $tpl->assign('ar',$ar);

                                                $tpl->assign('year',$all_year);
												//print('y:'.$y.' m:'.$m);
                                                $newsy = $news->getCountNewsByMonth($y,$m);
                                                //print_r($newsy);
                                                $tpl->assign('news',$newsy);
                                        }

//                                    $tpl->assign('art',$arts);
                                    $tpl->assign('include','raporty.tpl');
                            break;*/
                        /*
                                case 2:
                                        //o firmie
                                        $sub = $cat->getMenu(2);
                                        $tpl->assign('sub',$sub);
                                        $tpl->assign('cs',count($sub));
                                        if( empty($id))
                                        {
                                            $arts = $news->getWpis($strona);
                                        }
                                        else
                                        {
                                            $arts = $news->getWpis($id);
                                            if( empty($arts))
                                                $arts = "";
                                            if( $id == '19')
                                            {
                                                $foto = $gal->getAllZdjecia();
                                                $tpl->assign('foto',$foto);
                                                $ca = $cat->getMenu(19);
                                                $tpl->assign('scat',$ca);
                                            }
                                            if($id == 17)
                                            {
                                                if( !empty($_SESSION['msg']) )
                                                {
                                                    $alert = $text[$_SESSION['language']]['alert_praca'];
//                                                    print($alert);
                                                    unset($_SESSION['msg']);
                                                    $tpl->assign('alert',$alert);
                                                }
                                            }
                                        }
                                        $tpl->assign('art',$arts);


                                        $tpl->assign('include','tekstowa.tpl');
					break;
                                case 3:
                                        //produkty
                                        $sub = $cat->getMenu(3);
                                        $tpl->assign('sub',$sub);
                                        $tpl->assign('cs',count($sub));
                                        if(empty($id) && empty($it))
                                        {
                                            $arts = $news->getWpis(3);
                                            $tpl->assign('art',$arts);
                                            $tpl->assign('include','produkty.tpl');
                                        }
                                        else if( empty($it)){
                                            if( empty($k) )
                                            {
                                                $sub2 = $cat->getMenu($id);
                                                $tpl->assign('sub2',$sub2);

                                                $arts = $news->getWpis($id);
                                                $tpl->assign('art',$arts);

                                                $tpl->assign('include','produkty.tpl');
                                            }
                                            else
                                            {
                                                if( empty($pr))
                                                {
                                                    $sub2 = $cat->getMenu($id);
                                                    $tpl->assign('sub2',$sub2);

//                                                    $sub3 = $cat->getMenu($k);
//                                                    $tpl->assign('sub3',$sub3);

                                                    $pro = $prod->getProdsCat($k);
                                                    $tpl->assign('sub3',$pro);

                                                    $arts = $news->getWpis($k);
                                                    $tpl->assign('art',$arts);

                                                    $foto = $gal->getAllZdjecia();
                                                    $tpl->assign('foto',$foto);

                                                    $tpl->assign('include','produkt1.tpl');
                                                }
                                            }
                                        }
                                        else{
                                            $sub = $cat->getMenu(3);
                                        $tpl->assign('sub',$sub);
                                        $tpl->assign('cs',count($sub));

                                        $pro = $prod->getProds($it);
                                        $tpl->assign('pro',$pro);

                                        $cats = $cat->getcat($pro['kategoria']);
                                        $tpl->assign('cat',$cats);

                                        $tpl->assign('include','produkt2.tpl');
                                        }

                                        
					break;
                                case 7:
                                        //produkt
                                        $sub = $cat->getMenu(3);
                                        $tpl->assign('sub',$sub);
                                        $tpl->assign('cs',count($sub));

                                        $pro = $prod->getProds($id);
                                        $tpl->assign('pro',$pro);

                                        $cats = $cat->getcat($pro['kategoria']);
                                        $tpl->assign('cat',$cats);

                                        $tpl->assign('include','produkt2.tpl');
					break;
                                case 4:
                                        //usługi
                                        $sub = $cat->getMenu(4);
                                        $tpl->assign('sub',$sub);
                                        $tpl->assign('cs',count($sub));
                                        if( empty($id))
                                        {
                                            $arts = $news->getWpis($strona);
                                        }
                                        else
                                        {
                                            $arts = $news->getWpis($id);
                                        }                                        
                                        $tpl->assign('art',$arts);

                                        $tpl->assign('include','uslugi.tpl');
					break;
                                case 5:
                                        //kontakt
                                        $arts = $news->getWpis($strona);
                                        $tpl->assign('art',$arts);
//                                        print_r($_SESSION);

                                        if( !empty($_SESSION['err']) )
                                        {
                                            if( $_SESSION['err'] == 'E_ALL' )
                                                $err = $text[$_SESSION['language']]['eall'];
                                            else if( $_SESSION['err'] == 'REG' )
                                                $err = $text[$_SESSION['language']]['vreg'];
                                            else
                                                $err = $_SESSION['err'];
                                            $tpl->assign('err',$err);
                                            unset($_SESSION['err']);
                                        }
                                        if( !empty($_SESSION['msg']) )
                                        {
                                            $tpl->assign('alert',$text[$_SESSION['language']]['alert_kontakt']);
                                            unset($_SESSION['msg']);
                                        }

                                        $tpl->assign('include','kontakt.tpl');
					break;
                                case 6:
                                        //aktualności
                                        $sub = $cat->getMenu(2);
                                        $tpl->assign('sub',$sub);
                                        $tpl->assign('cs',count($sub));

                                        if( empty($id))
                                        {
                                            $n1 = $news->getAllNews();
                                            $tpl->assign('news',$n1);
                                            $tpl->assign('include','aktualnosci.tpl');
                                        }
                                        else
                                        {
                                            $new = $news->getOneNews($id);
                                            $tpl->assign('new',$new);
                                            $tpl->assign('include','aktualnosci1.tpl');
                                        }
					break;
                                case 8:
                                        //szukaj
                                        if($id == 1)
                                        {
                                            if( !empty($_POST) )
                                            {
                                                
                                            }
                                            $tpl->assign('include','szukaj.tpl');
                                        }
                                        else if($id == 2)
                                        {

                                        }
                                        else if( $id == 3)
                                        {
                                            
                                        }
					break;*/
                                case 666:
				    switch($_GET['lang']){
				     	case 'en':
				      		$_SESSION['language'] = 'en';
				      		break;
				     	case 'de':
				      		$_SESSION['language'] = 'de';
				      		break;
				     	case 'ru':
				     		$_SESSION['language'] = 'ru';
				     		break;
				     	default:
				      		$_SESSION['language'] = 'pl';
				      		break;
				    }
                                    header('Location: '.$_SERVER['HTTP_REFERER']);
				    break;
				default:
					break;
			}/* end switch */
			
		}
                $tpl->assign('let_error','');

		$tpl->display('index.tpl');


	}

	public static function toPermalink($string)
	{


		$unPretty = array('/ä/', '/ö/', '/ü/', '/Ä/', '/Ö/', '/Ü/', '/ß/',
		'/ą/', '/Ą/', '/ć/', '/Ć/', '/ę/', '/Ę/', '/ł/', '/Ł/' ,'/ń/', '/Ń/', '/ó/', '/Ó/', '/ś/', '/Ś/', '/ź/', '/Ź/', '/ż/', '/Ż/',
		'/Š/','/Ž/','/š/','/ž/','/Ÿ/','/Ŕ/','/Á/','/Â/','/Ă/','/Ä/','/Ĺ/','/Ç/','/Č/','/É/','/Ę/','/Ë/','/Ě/','/Í/','/Î/','/Ď/','/Ń/',
		'/Ň/','/Ó/','/Ô/','/Ő/','/Ö/','/Ř/','/Ů/','/Ú/','/Ű/','/Ü/','/Ý/','/ŕ/','/á/','/â/','/ă/','/ä/','/ĺ/','/ç/','/č/','/é/','/ę/',
		'/ë/','/ě/','/í/','/î/','/ď/','/ń/','/ň/','/ó/','/ô/','/ő/','/ö/','/ř/','/ů/','/ú/','/ű/','/ü/','/ý/','/˙/',
		'/Ţ/','/ţ/','/Đ/','/đ/','/ß/','/Œ/','/œ/','/Ć/','/ć/','/ľ/');

		$pretty   = array('ae', 'oe', 'ue', 'Ae', 'Oe', 'Ue', 'ss',
		'a', 'A', 'c', 'C', 'e', 'E', 'l', 'L', 'n', 'N', 'o', 'O', 's', 'S', 'z', 'Z', 'z', 'Z',
		'S','Z','s','z','Y','A','A','A','A','A','A','C','E','E','E','E','I','I','I','I','N',
		'O','O','O','O','O','O','U','U','U','U','Y','a','a','a','a','a','a','c','e','e','e',
		'e','i','i','i','i','n','o','o','o','o','o','o','u','u','u','u','y','y',
		'TH','th','DH','dh','ss','OE','oe','AE','ae','u');

		$permalink = strtolower(preg_replace($unPretty, $pretty, $string));
		return  str_replace(" ", "-", preg_replace("/[^a-zA-Z0-9 ]/", "", $permalink) );

	}

	public static function pathToNode($id,$s='1')
	{
		$db = Zend_Registry::get('db');

		if(!empty($id))
		{
			$sql = "SELECT lleft, rright FROM cms_drzewko WHERE id=".(int)$id;
			$results = $db->fetchAll($sql);

			if(!empty($results))
			{
				$sql = "SELECT * FROM cms_drzewko WHERE lleft <=".$results[0]['lleft']." AND rright >=".$results[0]['rright']." ORDER BY id";
				$results = $db->fetchAll($sql);

				$countResults = count($results);

				$path = null;
				$tab = array();

				for($i=0;$i<$countResults;$i++)
				{
					if($results[$i]['id']==1) $path .= '';
					else if($results[$i]['parent_id']==1) $path .= '';

					else $tab[$i]= ucfirst($results[$i]['nazwa']);
				}

				$path = join(' / ',$tab);
			}
		}

		else $path ='';

		return $path;

	}

        public static function usun_ogonki($str)
	{
		$trans = array(
						"Ą" => "a", "ą" => "a", "Ć" => "c", "ć" => "c", "Ę" => "e",
						"ę" => "e", "Ł" => "l", "ł" => "l", "Ó" => "o","ó" => "o",
						"Ń" => "n","ń" => "n","Ś" => "s","ś"=> "s","Ź" => "z",
						"ź"=> "z","Ż" => "z","ż" => "z","," => "");

		return strtr($str, $trans);
	}
}
?>
