$(document).ready(function(){
	
	/********************************/
	/*	MENU						*/
	var navElements = $('header > nav');
	var movingNavBg = navElements.children('div');
	var active = navElements.children('a.active');
	
	function moveToMenu(element)
	{
		movingNavBg
			.height(parseInt(element.height()+parseInt(element.css('paddingTop'))*2))
			.animate({
				left: element.position().left+"px",
				width: parseInt(element.width()+parseInt(element.css('paddingLeft'))*2)
			},{
				queue: false,
				duration: 300,
				complete: function(){
						$('.slideOn').removeClass('slideOn');
						element.addClass('slideOn');
				}
			});
	}
	
	$('header > nav > a').hover(function(){
		moveToMenu($(this));
	},function(){
		moveToMenu(active);
	});
	
	/*
	$('img').load(function(){ // <= FireFox doesn't understand
		$('header > nav > a.active').trigger('mouseenter');
	});
	moveToMenu($('header > nav > a.active'));
	*/
	$(window).load(function(){
		moveToMenu($('header > nav > a.active'));
	});
	
	/********************************/
	/*	FADER						*/
	var slideBox	= $('#slides, #slides_min');
	var slideNav	= $('#fader nav');
	var timeout		= 5000;
	var anim_time	= 3000;
	var slideHeader	= $('#fader > hgroup > h1');
	var countSlides = slideBox.children('img').length;
	
	function slideNavUpdate()
	{
		if(slideNav.children('div').length!=countSlides)
		{
			for(i=1;i<=countSlides;i++) slideNav.append('<div></div>');
			var singleWidth = slideNav.children('div').first().width() + 2*parseInt(slideNav.children('div').first().css('marginLeft')) + 2*parseInt(slideNav.children('div').first().css('borderWidth'));
			slideNav.width(parseInt(countSlides*singleWidth)+'px');
		}
		$.each(slideNav.children('div'), function(index, element){
			if(slideBox.children('img').eq(index).hasClass('active'))
				slideNav.children('div').eq(index).addClass('active').fadeTo('slow', 1);
			else
				slideNav.children('div').eq(index).removeClass('active').fadeTo('slow', 0.5);
		});
	}
	
	function slideSwitch()
	{
		var $active = slideBox.children('img.active');
		if ($active.length == 0) $active = slideBox.children('img:first');
		var $next =  $active.next('img').length ? $active.next('img') : slideBox.children('img:first');
		$active.removeClass('active').fadeOut(anim_time);
		$next.addClass('active').fadeIn(anim_time);
		if(slideHeader.length>0 && $next.attr('alt')!='')
			slideHeader.fadeOut(parseInt(anim_time/2), function(){
				$(this).html($next.attr('alt')).fadeIn(parseInt(anim_time/2));
			});
		slideNavUpdate();
	}
	
	function slideInit()
	{
		slideHeader.hide().html(slideBox.children('img:first').attr('alt')).fadeIn(anim_time);
		slideBox.children('img:first').addClass('active').show();
		setTimeout(function(){
			slideSwitch();
			setInterval(slideSwitch, timeout+anim_time);
		},timeout);
		slideNavUpdate();
	}
	
	slideInit();
	
	/********************************/
	/*	OTHERS						*/
	
	$('.gallery > a').lightBox();
	$('section.subpage > h2').click(function(){
		$(this).toggleClass('active').siblings('div').slideToggle('slow');
	});
	$('input[type="submit"]').click(function(e){
		var nie_wypelnione=$('.required > input, .required > textarea');
		nie_wypelnione.each(function(){
			if($(this).val()==''){
				$(this).addClass('pointAttention');
				$('#requiredInfo').fadeIn('slow');
				e.preventDefault();
			}
		});
	});
	$('.required > input, .required > textarea').click(function(){
		$(this).removeClass('pointAttention');
		$('#requiredInfo').fadeOut('slow');
	});
	$('#content > nav > a').hover(function(){
		$(this).animate({paddingLeft: '10px'}, { queue: false, duration: 150 });
	}, function(){
		$(this).animate({paddingLeft: '5px'}, { queue: false, duration: 300 });
	});

	//Cufon.replace('header > #fader > section > h1, header > #fader > hgroup > h1, header > #fader_min > hgroup > h1', { fontFamily: 'MuseoSans100Regular' });
	
	$('#debuger').height('10').click(function(){
		if($(this).height()=='10')
			$(this).height($(this).children('pre').height());
		else
			$(this).height('10');
	});
});