<?php
/**
 * Klasa do obsługi modułu seo.
 * Zarzadzanie plikiem robots.txt
 * @author Bartosz Strzała
 * @package Seo
 * @version 0.1
 */

class Seo
{
	const robots_file = '../robots.txt';
	const htaccess_file = '../.htaccess';
	const p = 11;

	
	public function menu()
	{
		$smarty = Zend_Registry::get('smarty');

		$submenu[0]['link'] = '?p='.self::p.'&a=1&f=1';
		$submenu[0]['tekst'] = 'Zmień zawartośc pliku robots.txt';
		
		$submenu[1]['link'] = '?p='.self::p.'&a=1&f=2';
		$submenu[1]['tekst'] = 'Zmień zawartośc pliku .htaccess';
		
		$submenu[2]['link'] = '?p='.self::p.'&a=3';
		$submenu[2]['tekst'] = 'Zmień meta tagi';
		
		$this->konfiguracja();

		$smarty->assign('lista', ' ');
		$smarty->assign('submenu', $submenu);
		//$smarty->assign('robots', nl2br(self::getContentRobots()));
		//$smarty->assign('htaccess', nl2br(self::getContentRobots(self::htaccess_file)));
	}
	
	public function konfiguracja()
    {
        $tpl = Zend_Registry::get('smarty');

        $conf = $this->getConf();
        $tpl->assign('conf',$conf);
        
        $chmod = $this->getChmod();
        $tpl->assign('chmod',$chmod);
        
        $err = $chmod['error_chmod'];
        //print($err);
        if( $err == 1 && $err >= 5)
        {
        	$tpl->assign('l1','jest');
        	$tpl->assign('l2','błąd');
        }
    	if( $err >= 2 && $err <= 4)
        {
        	$tpl->assign('l1','są');
        	$tpl->assign('l2','błędy');
        }
    }

    public function getConf()
    {
        $conf['version'] = '3.1';
        $conf['php_version'] = phpversion();

        $db = Zend_Registry::get('db');
        $sql = 'SELECT version() as ver';
        $row = $db->fetchRow($sql);

        $conf['mysql_version'] = $row['ver'];
        $conf['server_ip'] = $_SERVER[SERVER_ADDR];
        $conf['server_name'] = $_SERVER[SERVER_NAME];
        $conf['server_software'] = $_SERVER[SERVER_SOFTWARE];
        $conf['server_protocol'] = $_SERVER[SERVER_PROTOCOL];
        $conf['user'] = $_SERVER[HTTP_USER_AGENT];

        //print_r($conf);
        return $conf;
    }

    public function getChmod()
    {
        // chmod robots
        $dir1 = '../robots.txt';
        if( !is_file($dir1))
            $file['robots']['isset'] = 0;
        else
            $file['robots']['isset'] = 1;
        $file['robots']['dir'] = $dir1;
        $c1 = substr(decoct(fileperms($dir1)),3);
        $file['robots']['chmod'] = $c1;
        if( $c1 != '777'){
            $file['error_chmod'] = $file['error_chmod'] +1;
            $file['robots']['error'] = 1;
        }
        // chmod htaccess
        $dir2 = '../.htaccess';
        if( !is_file($dir2))
            $file['htaccess']['isset'] = 0;
        else
            $file['htaccess']['isset'] = 1;
        $file['htaccess']['dir'] = $dir2;
        $c2 = substr(decoct(fileperms($dir2)),3);
        $file['htaccess']['chmod'] = $c2;
        if( $c2 != '777'){
            $file['error_chmod'] = $file['error_chmod'] +1;
            $file['htaccess']['error'] = 1;
        }
        // chmod templates_c
        $dir3 = '../templates_c/';
        if( !is_dir($dir3))
            $file['templates_c']['isset'] = 0;
        else
            $file['templates_c']['isset'] = 1;
        $file['templates_c']['dir'] = $dir3;
        $c3 = substr(decoct(fileperms($dir3)),2);
        $file['templates_c']['chmod'] = $c3;
        if( $c3 != '777'){
            $file['error_chmod'] = $file['error_chmod'] +1;
            $file['templates_c']['error'] = 1;
        }
        // chmod galeria
        $dir4 = '../gallery/';
        if( !is_dir($dir4))
            $file['galeria']['isset'] = 0;
        else
            $file['galeria']['isset'] = 1;
        $file['galeria']['dir'] = $dir4;
        $c4 = substr(decoct(fileperms($dir4)),2);
        $file['galeria']['chmod'] = $c4;
        if( $c4 != '777'){
            $file['error_chmod'] = $file['error_chmod'] +1;
            $file['galeria']['error'] = 1;
        }
        /*
        // chmod galeria/crop
        $dir5 = '../galeria/crop/';
        if( !is_dir($dir5))
            $file['galeria_crop']['isset'] = 0;
        else
            $file['galeria_crop']['isset'] = 1;
        $file['galeria_crop']['dir'] = $dir5;
        $c5 = substr(decoct(fileperms($dir5)),2);
        $file['galeria_crop']['chmod'] = $c5;
        if( $c5 != '777'){
            $file['error_chmod'] = $file['error_chmod'] +1;
            $file['galeria_crop']['error'] = 1;
        }
        */
        // chmod galeria/min
/*        $dir6 = '../galeria/min/';
        if( !is_dir($dir6))
            $file['galeria_min']['isset'] = 0;
        else
            $file['galeria_min']['isset'] = 1;
        $file['galeria_min']['dir'] = $dir6;
        $c6 = substr(decoct(fileperms($dir6)),2);
        $file['galeria_min']['chmod'] = $c6;
        if( $c6 != '777'){
            $file['error_chmod'] = $file['error_chmod'] +1;
            $file['galeria_min']['error'] = 1;
        }
        // chmod files
        $dir7 = '../files/';
        if( !is_dir($dir7))
            $file['files']['isset'] = 0;
        else
            $file['files']['isset'] = 1;
        $file['files']['dir'] = $dir7;
        $c7 = substr(decoct(fileperms($dir7)),2);
        $file['files']['chmod'] = $c7;
        if( $c7 != '777'){
            $file['error_chmod'] = $file['error_chmod'] +1;
            $file['files']['error'] = 1;
        }
*/
        // chmod cms/templates_c/
        $dir8 = '../cms/templates_c/';
        if( !is_dir($dir8))
            $file['cms_templates_c']['isset'] = 0;
        else
            $file['cms_templates_c']['isset'] = 1;
        $file['cms_templates_c']['dir'] = $dir8;
        $c8 = substr(decoct(fileperms($dir8)),2);
        $file['cms_templates_c']['chmod'] = $c8;
        if( $c8 != '777'){
            $file['error_chmod'] = $file['error_chmod'] +1;
            $file['cms_templates_c']['error'] = 1;
        }
        // chmod cms/js/xinha/plugins/ExtendedFileManager/upload/
        $dir9 = '../cms/js/xinha/plugins/ExtendedFileManager/upload/';
        if( !is_dir($dir9))
            $file['xinha']['isset'] = 0;
        else
            $file['xinha']['isset'] = 1;
        $file['xinha']['dir'] = $dir9;
        $c9 = substr(decoct(fileperms($dir9)),2);
        $file['xinha']['chmod'] = $c9;
        if( $c9 != '777'){
            $file['error_chmod'] = $file['error_chmod'] +1;
            $file['xinha']['error'] = 1;
        }
		/*
        // chmod translation/
        $dir10 = '../translation/';
        if( !is_dir($dir10))
            $file['translation']['isset'] = 0;
        else
            $file['translation']['isset'] = 1;
        $c10 = substr(decoct(fileperms($dir10)),2);
        $file['translation']['chmod'] = $c10;
        // chmod translation/pl/
        $dir11 = '../translation/pl/';
        if( !is_dir($dir11))
            $file['translation_pl']['isset'] = 0;
        else
            $file['translation_pl']['isset'] = 1;
        $c11 = substr(decoct(fileperms($dir11)),2);
        $file['translation_pl']['chmod'] = $c11;
        // chmod translation/pl/pl.php
        $dir12 = '../translation/pl/pl.php';
        if( !is_file($dir12))
            $file['translation_pl_pl']['isset'] = 0;
        else
            $file['translation_pl_pl']['isset'] = 1;
        $c12 = substr(decoct(fileperms($dir12)),3);
        $file['translation_pl_pl']['chmod'] = $c12;
        // chmod translation/en/
        $dir13 = '../translation/en';
        if( !is_dir($dir13))
            $file['translation_en']['isset'] = 0;
        else
            $file['translation_en']['isset'] = 1;
        $c13 = substr(decoct(fileperms($dir13)),2);
        $file['translation_en']['chmod'] = $c13;
        // chmod translation/pl/pl.php
        $dir14 = '../translation/en/en.php';
        if( !is_file($dir14))
            $file['translation_en_en']['isset'] = 0;
        else
            $file['translation_en_en']['isset'] = 1;
        $c14 = substr(decoct(fileperms($dir14)),3);
        $file['translation_en_en']['chmod'] = $c14;
        // chmod translation/de/
        $dir15 = '../translation/de';
        if( !is_dir($dir15))
            $file['translation_de']['isset'] = 0;
        else
            $file['translation_de']['isset'] = 1;
        $c15 = substr(decoct(fileperms($dir15)),2);
        $file['translation_de']['chmod'] = $c15;
        // chmod translation/pl/pl.php
        $dir16 = '../translation/de/de.php';
        if( !is_file($dir16))
            $file['translation_de_de']['isset'] = 0;
        else
            $file['translation_de_de']['isset'] = 1;
        $c16 = substr(decoct(fileperms($dir16)),3);
        $file['translation_de_de']['chmod'] = $c16;
        // chmod translation/fr/
        $dir17 = '../translation/fr';
        if( !is_dir($dir17))
            $file['translation_fr']['isset'] = 0;
        else
            $file['translation_fr']['isset'] = 1;
        $c17 = substr(decoct(fileperms($dir17)),2);
        $file['translation_fr']['chmod'] = $c17;
        // chmod translation/pl/pl.php
        $dir18 = '../translation/fr/fr.php';
        if( !is_file($dir18))
            $file['translation_fr_fr']['isset'] = 0;
        else
            $file['translation_fr_fr']['isset'] = 1;
        $c18 = substr(decoct(fileperms($dir18)),3);
        $file['translation_fr_fr']['chmod'] = $c18;
        // chmod translation/ru/
        $dir19 = '../translation/ru';
        if( !is_dir($dir19))
            $file['translation_ru']['isset'] = 0;
        else
            $file['translation_ru']['isset'] = 1;
        $c19 = substr(decoct(fileperms($dir19)),2);
        $file['translation_ru']['chmod'] = $c19;
        // chmod translation/ru/ru.php
        $dir20 = '../translation/ru/ru.php';
        if( !is_file($dir20))
            $file['translation_ru_ru']['isset'] = 0;
        else
            $file['translation_ru_ru']['isset'] = 1;
        $c20 = substr(decoct(fileperms($dir20)),3);
        $file['translation_ru_ru']['chmod'] = $c20;
        // chmod translation/es/
        $dir21 = '../translation/es';
        if( !is_dir($dir21))
            $file['translation_es']['isset'] = 0;
        else
            $file['translation_es']['isset'] = 1;
        $c21 = substr(decoct(fileperms($dir21)),2);
        $file['translation_es']['chmod'] = $c21;
        // chmod translation/pl/pl.php
        $dir22 = '../translation/es/es.php';
        if( !is_file($dir22))
            $file['translation_es_es']['isset'] = 0;
        else
            $file['translation_es_es']['isset'] = 1;
        $c22 = substr(decoct(fileperms($dir22)),3);
        $file['translation_es_es']['chmod'] = $c22;
        // chmod translation/it/
        $dir23 = '../translation/it';
        if( !is_dir($dir23))
            $file['translation_it']['isset'] = 0;
        else
            $file['translation_it']['isset'] = 1;
        $c23 = substr(decoct(fileperms($dir23)),2);
        $file['translation_it']['chmod'] = $c23;
        // chmod translation/pl/pl.php
        $dir24 = '../translation/it/it.php';
        if( !is_file($dir24))
            $file['translation_it_it']['isset'] = 0;
        else
            $file['translation_it_it']['isset'] = 1;
        $c24 = substr(decoct(fileperms($dir24)),3);
        $file['translation_it_it']['chmod'] = $c24;
		*/
        return $file;
    }
	
	public static function getContentRobots($file_name = '../robots.txt')
	{
		try
		{
			if(!file_exists($file_name)) {
				throw new Exception('Brak pliku '.$file_name.'.');
			}
				
			if(!is_writable($file_name)) {
				throw new Exception('Plik '.$file_name.' nie ma nadanych uprawnień do zapisu.');
			}
				
			$file = fopen($file_name,'r');
				
			return fread($file, filesize($file_name));
		}

		catch (Zend_Db_Adapter_Exception $e)
		{
			Index::przechwyc_blad($e);
		}
			
		catch (Zend_Exception $e)
		{
			Index::przechwyc_blad($e);
		}
	}
	
	public static function setContentRobots($file_name = '../robots.txt')
	{
		try
		{
			if(!file_exists($file_name)) {
				throw new Exception('Brak pliku '.$file_name.'.');
			}
				
			if(!is_writable($file_name)) {
				throw new Exception('Plik '.$file_name.' nie ma nadanych uprawnień do zapisu.');
			}
				
			$file = fopen($file_name,'w+');
				
			fwrite($file,$_POST['plik']);
		}

		catch (Zend_Db_Adapter_Exception $e)
		{
			Index::przechwyc_blad($e);
		}
			
		catch (Zend_Exception $e)
		{
			Index::przechwyc_blad($e);
		}
	}

	public function form($file_name = '../robots.txt')
	{
		$akcja= 'edycja';
		$new = new generatorFormularzy('Robots','./index.php?p='.self::p.'&a=2','POST','', true);
		$new->poczatekForm();

		$robotstxt = self::getContentRobots($file_name);

		$new->textarea('Plik', 20, 80,'',!empty($robotstxt) ? $robotstxt : '');

		$new->text('<br />');

		$new->inupt('r','r', 'hidden',time(),'','',false);
		$new->inupt('file_name', 'hidden',$file_name,'','',false);

		$new->inupt('ok','ok', 'submit',ucfirst($akcja),'','searchbutton',false);
		$new->text('<br />');
		$new->koniecForm();
	}
	
	public function formMeta($akcja='dodaj')
	{
		$sql = 'SELECT * FROM '.Index::dbPrefiks.'meta;';
		$db = Zend_Registry::get('db');
		
		$tab = $db->fetchRow($sql);
				
		$new = new generatorFormularzy('Meta tagi','./index.php?p='.self::p.'&a=4','POST','',true);
		$new->poczatekForm();
		//$new->textarea('Tytul', 10, 80,'',!empty($tab['tytul']) ? stripslashes($tab['tytul']) : '');
		$new->textarea('Tytul', 10, 80,'',stripslashes($tab['tytul']),'textlong','tytul');
		$new->text('<br /><br />');
		//$new->textarea('Opis strony', 10, 80,'',!empty($tab['opis']) ? stripslashes($tab['opis']) : '');
		$new->textarea('Opis strony', 10, 80,'',stripslashes($tab['opis']),'textlong','opis_strony');
		$new->text('<br /><br />');
		//$new->textarea('Słowa kluczowe', 10, 80,'',!empty($tab['slowa']) ? stripslashes($tab['slowa']) : '');
		$new->textarea('Słowa kluczowe', 10, 80,'',stripslashes($tab['slowa']),'textlong','slowa_kluczowe');
		$new->text('<br /><br />');
		$new->inupt('ok','ok', 'submit',ucfirst($akcja),'','searchbutton',false);

		$new->inupt('r','r', 'hidden',time(),'','',false);
		$new->inupt('akcja','akcja', 'hidden',$akcja,'','',false);
		$new->inupt('id','id' ,'hidden',$_GET['nr'],'','',false);
		$new->koniecForm();
	}
	
	public function addMeta()
	{
		Zend_Loader::loadClass('Zend_Filter_StripTags');
		$filtr = new Zend_Filter_StripTags();
			
		if($_SESSION['form']==$_POST['r'])throw new Exception('Nie odświeżaj strony!');
		$_SESSION['form'] = $_POST['r'];
			
		$data = array();
		$data['tytul'] = ucfirst($filtr->filter($_POST['tytul']));
		$data['slowa'] = $filtr->filter($_POST['slowa_kluczowe']);
		$data['opis'] =  $filtr->filter($_POST['opis_strony']);

		$db = Zend_Registry::get('db');

		$db->update(Index::dbPrefiks.'meta', $data,'id=1');

		$smarty = Zend_Registry::get('smarty');
		$smarty->assign('komunikat', array('typ'=>'info','tekst'=>'Dane zostały zmienione'));
		$this->menu();
	}

	public function add()
	{
		try
		{
			$smarty = Zend_Registry::get('smarty');

			self::setContentRobots($_POST['file_name']);
			
			$smarty->assign('komunikat', array('typ' => 'info', 'tekst' => 'Plik '.$file_name.' został zmieniony.'));
			$this->menu();

		}
			
		catch (Zend_Db_Adapter_Exception $e)
		{
			Index::przechwyc_blad($e);
		}
			
		catch (Zend_Exception $e)
		{
			Index::przechwyc_blad($e);
		}
	}

	/**
	 * Funkcja czyszczaca nazwa z wszelich nie potrzebnych znakow.
	 *
	 * @param string $string
	 * @return string
	 */

	public static function clearName($string)
	{
		$unPretty = array('/ä/', '/ö/', '/ü/', '/Ä/', '/Ö/', '/Ü/', '/ß/', 
	                            '/ą/', '/Ą/', '/ć/', '/Ć/', '/ę/', '/Ę/', '/ł/', '/Ł/' ,'/ń/', '/Ń/', '/ó/', '/Ó/', '/ś/', '/Ś/', '/ź/', '/Ź/', '/ż/', '/Ż/',
	                            '/Š/','/Ž/','/š/','/ž/','/Ÿ/','/Ŕ/','/Á/','/Â/','/Ă/','/Ä/','/Ĺ/','/Ç/','/Č/','/É/','/Ę/','/Ë/','/Ě/','/Í/','/Î/','/Ď/','/Ń/',
	                            '/Ň/','/Ó/','/Ô/','/Ő/','/Ö/','/Ř/','/Ů/','/Ú/','/Ű/','/Ü/','/Ý/','/ŕ/','/á/','/â/','/ă/','/ä/','/ĺ/','/ç/','/č/','/é/','/ę/',
	                            '/ë/','/ě/','/í/','/î/','/ď/','/ń/','/ň/','/ó/','/ô/','/ő/','/ö/','/ř/','/ů/','/ú/','/ű/','/ü/','/ý/','/˙/',
	                            '/Ţ/','/ţ/','/Đ/','/đ/','/ß/','/Œ/','/œ/','/Ć/','/ć/','/ľ/');

		$pretty   = array('ae', 'oe', 'ue', 'Ae', 'Oe', 'Ue', 'ss',
	                            'a', 'A', 'c', 'C', 'e', 'E', 'l', 'L', 'n', 'N', 'o', 'O', 's', 'S', 'z', 'Z', 'z', 'Z',
	                            'S','Z','s','z','Y','A','A','A','A','A','A','C','E','E','E','E','I','I','I','I','N',
	                            'O','O','O','O','O','O','U','U','U','U','Y','a','a','a','a','a','a','c','e','e','e',
	                            'e','i','i','i','i','n','o','o','o','o','o','o','u','u','u','u','y','y',
	                            'TH','th','DH','dh','ss','OE','oe','AE','ae','u');

		$permalink = strtolower(preg_replace($unPretty, $pretty, $string));
		return  str_replace(" ", "-", preg_replace("/[^a-zA-Z0-9 ]/", "", $permalink) );
	}
}
?>
