<?php
session_start();
define ('PREFIKS', 'cms_');
class Index
{
	const dbPrefiks = PREFIKS;

	public function __construct()
	{
		/*
		 * bootstrap
		 */
		
		session_cache_limiter("private_no_expire");

		header("Cache-Control: no-store, no-cache, must-revalidate");
		header("Content-Type: text/html; charset=utf-8;");
		
		if( empty($_SESSION['langs']))
			$_SESSION['langs'] = 'pl';

		if(isset($_POST['a']) && $_POST['a']=='zalogowany')
			header('Location: ./index.php?p=4');
		
		if(isset($_GET['a']) && $_GET['a']=='wyloguj')
		{
			session_destroy();
			header('Location: ./index.php');
		}

                if( !isset($_SESSION['language']) )
                    $_SESSION['language'] = 'pl';
                if( !isset($_SESSION['lang']) )
                    $_SESSION['lang'] = 'pl';
                    
        //print_r($_SESSION);
		
		date_default_timezone_set('Europe/Warsaw');

		set_include_path('.' . PATH_SEPARATOR . 'library' . PATH_SEPARATOR . get_include_path());
		
		set_include_path('.' . PATH_SEPARATOR . 'php/modules' . PATH_SEPARATOR . get_include_path());

		include "Zend/Loader.php";
		Zend_Loader::registerAutoload();

		$config = new Zend_Config_Ini ('./config/config.ini', 'glowne');
		$configBaza = new Zend_Config_Ini ('./config/config.ini', 'baza');
		$registry = Zend_Registry::getInstance();

		error_reporting($config->raportowanie);
		//error_reporting(E_ALL);

		$db = Zend_Db::factory($configBaza->db->adapter, $configBaza->db->config->toArray());
		Zend_Db_Table::setDefaultAdapter($db);
		$db->query('SET NAMES utf8');
		$db->query('SET CHARACTER SET utf8');

		$registry->set('db', $db);
		$registry->set('config', $config);
		$registry->set('configBaza', $configBaza);
		
		require_once('Smarty/Smarty.class.php');
		$smarty = new Smarty;		
		
		$registry->set('smarty', $smarty);
		
		require_once'./php/klasy/generatorFormularzy.php';
	}

	public static function pobiez_ip()
	{
		if(!empty($_SERVER['HTTP_CLIENT_IP']))
		$adresIp = $_SERVER['HTTP_CLIENT_IP'];
		else if(!empty($_SERVER['HTTP_X_FORWARDED_FOR']))
		$adresIp = $_SERVER['HTTP_X_FORWARDED_FOR'];
		else if(!empty($_SERVER['REMOTE_ADDR']))
		$adresIp = $_SERVER['REMOTE_ADDR'];

		if(strpos($adresIp, ',') !== false)
		{
			$adresIp = explode(',', $adresIp);
			$adresIp = $adresIp[0];
		}

		return $adresIp ? $adresIp :  'NIEZNANE';
	}

	public static function przechwyc_blad($e)
	{
		
		$smarty = Zend_Registry::get('smarty'); 
		$smarty->assign('nr',$e->getCode());
		$smarty->assign('msg',$e->getMessage());
	}
	
	public static function usun_ogonki($str)
	{
		$trans = array(
						"Ą" => "a", "ą" => "a", "Ć" => "c", "ć" => "c", "Ę" => "e", 
						"ę" => "e", "Ł" => "l", "ł" => "l", "Ó" => "o","ó" => "o",
						"Ń" => "n","ń" => "n","Ś" => "s","ś"=> "s","Ź" => "z",
						"ź"=> "z","Ż" => "z","ż" => "z","," => "", " "=> "_");
		
		return strtr($str, $trans);
	}
}
?>
