<?php
/*
* File: SimpleImage.php
* Author: Simon Jarvis
* Extension: Michał Adamski -2012- michaladamski.pl
* Copyright: 2006 Simon Jarvis
* Date: 08/11/06
* Link: http://www.white-hat-web-design.co.uk/articles/php-image-resizing.php
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details:
* http://www.gnu.org/licenses/gpl.html
*
*/
 
class SimpleImage {
 
   var $image;
   var $image_type;
   var $filename;
   private $image_temp;
   private $palette;
 
   function load($filename) {
      $this->filename = $filename;
      $image_info = getimagesize($filename);
      $this->image_type = $image_info['mime'];
      switch($this->image_type)
      {
      	case "image/jpeg":
      		$this->image = imagecreatefromjpeg($filename);
      		break;
      	case "image/png":
      		$this->image = imagecreatefrompng($filename);
      		$this->palette = (imagecolortransparent($this->image)<0);
      		break;
      	case "image/gif":
      		$this->image = imagecreatefromgif($filename);
      		break;      		
      }	
   }
   function save($filename, $compression=75, $permissions=null) 
   {
		switch($this->image_type)
      	{
      		case "image/jpeg":
      			imagejpeg($this->image,$filename,$compression);
      			break;
      		case "image/png":
	      		imagepng($this->image,$filename);
    	  		break;
      		case "image/gif":
      			imagegif($this->image,$filename);
      			break;      		
      	}	
      if( $permissions != null) {
 
         chmod($filename,$permissions);
      }
   }
   function output() 
   {
   		switch($this->image_type)
      	{
      		case "image/jpeg":
      			imagejpeg($this->image);
      			break;
      		case "image/png":
	      		imagepng($this->image);
    	  		break;
      		case "image/gif":
      			imagegif($this->image);
      			break;      		
      	}
   }
   function getWidth() {
 
      return imagesx($this->image);
   }
   function getHeight() {
 
      return imagesy($this->image);
   }
   function resizeToHeight($height) {
 
      $ratio = $height / $this->getHeight();
      $width = $this->getWidth() * $ratio;
      $this->resize($width,$height);
   }
 
   function resizeToWidth($width) {
      $ratio = $width / $this->getWidth();
      $height = $this->getheight() * $ratio;
      $this->resize($width,$height);
   }
 
   function scale($scale) {
      $width = $this->getWidth() * $scale/100;
      $height = $this->getheight() * $scale/100;
      $this->resize($width,$height);
   }
 
   function resize($width,$height) {
      $this->image_temp = imagecreatetruecolor($width, $height);
      $this->_preserve_alpha($width, $height);
      imagecopyresampled($this->image_temp, $this->image, 0, 0, 0, 0, $width, $height, $this->getWidth(), $this->getHeight());
      $this->image = $this->image_temp;
   }
   
/*
 * EXTENSION
 */

	function resizeMaxInBounds($width, $height)
	{
		$ratio_oryginal	= $this->getWidth()/$this->getHeight();
   		$ratio_thumb	= $width/$height;
   		if($ratio_oryginal>$ratio_thumb)
   		{
   			// horizontal
   			if($this->getWidth()>$width)
   				$this->resizeToWidth($width);
   			else
   				$this->resize($this->getWidth(), $this->getHeight()); // left to preserve alpha channel
   		}
   		else 
   		{
   			// vertical
   			if($this->getHeight()>$height)
   				$this->resizeToHeight($height);
   			else
   				$this->resize($this->getWidth(), $this->getHeight()); // left to preserve alpha channel
   		}
	}
	
	function crop($width,$height)
	{
   		$ratio_oryginal	= $this->getWidth()/$this->getHeight();
   		$ratio_thumb	= $width/$height;
   		if($ratio_oryginal>$ratio_thumb)
   		{
   			// cutting sides
   			$this->resizeToHeight($height);
   			$src_w = $width;
   			$src_h = $this->getHeight();
   			$src_x = (int)(($this->getWidth()-$width)/2);
   			$src_y = 0;
   			$this->image_temp = imagecreatetruecolor($width, $height);
   			$this->_preserve_alpha($width, $height);
   			imagecopyresampled($this->image_temp, $this->image, 0, 0, $src_x, $src_y, $width, $height, $src_w, $src_h);
   		}
   		else if($ratio_oryginal<$ratio_thumb)
   		{
   			// cutting from up and below
   			$this->resizeToWidth($width);
   			$src_w = $this->getWidth();
   			$src_h = $height;
   			$src_x = 0;
   			$src_y = (int)(($this->getHeight()-$height)/2);
   			$this->image_temp = imagecreatetruecolor($width, $height);
   			//if($this->image_type=="image/png")
   			//{
   			//	imagealphablending($this->image_temp, false);
			//	imagesavealpha($this->image_temp, true);
   			//}
   			$this->_preserve_alpha($width, $height);
   			imagecopyresampled($this->image_temp, $this->image, 0, 0, $src_x, $src_y, $width, $height, $src_w, $src_h);
   		}
   		else 
   		{
   			// square
   			$this->resize($width,$height);
   		}
   		$this->image = $this->image_temp;
   }
	
	function fill($width, $height, $r=255, $g=255, $b=255)
	{
		$ratio_oryginal	= $this->getWidth()/$this->getHeight();
   		$ratio_thumb	= $width/$height;
   		$new_image		= imagecreatetruecolor($width, $height);
   		$color			= imagecolorallocate($new_image, $r, $g, $b);
   		imagefill($new_image, 0, 0, $color);
   		if($ratio_oryginal>$ratio_thumb)
   		{
   			$this->resizeToWidth($width);
   			$dst_x = 0;
   			$dst_y = (int)(($height-$this->getHeight())/2);
   		}
   		else
   		{
   			$this->resizeToHeight($height);
   			$dst_x = (int)(($width-$this->getWidth())/2);
   			$dst_y = 0;
   		}
   		imagecopyresampled($new_image, $this->image, $dst_x, $dst_y, 0, 0, $this->getWidth(), $this->getHeight(), $this->getWidth(), $this->getHeight());
		$this->image = $new_image;
	}
	
	private function _preserve_alpha($w, $h)
	{
		if ($this->image_type == 'image/png')
		{
			// Idea borrowed from
			// http://perplexed.co.uk/1814_png_optimization_with_gd_library.htm
			// no author - sorry
			if(!$this->palette || (ord(file_get_contents ($this->filename, false, null, 25, 1)) & 4))
			{
				if(($tc=imagecolorstotal($this->image))&&$tc<=256)
					imagetruecolortopalette($this->image_temp, false, $tc);
				imagealphablending($this->image_temp, false);
				$alpha = imagecolorallocatealpha($this->image_temp, 0, 0, 0, 127);
				imagefill($this->image_temp, 0, 0, $alpha);
				imagesavealpha($this->image_temp, true);
			}
		}
	}
	
	private function _check_PNG_pallete()
	{
		// NOT used
		// borrowed from:
		// http://perplexed.co.uk/1814_png_optimization_with_gd_library.htm
		// no author - sorry
		if((ord(file_get_contents ($this->filename, false, null, 25, 1)) & 4))
		{
			$dx = min(max(floor($this->getWidth()/50),1),10);
			$dy = min(max(floor($this->getHeight()/50),1),10);
		
			$this->palette = true;
			for($x=0;$x<$this->getWidth();$x=$x+$dx){
				for($y=0;$y<$this->getHeight();$y=$y+$dy){
					$col = imagecolorsforindex($this->image, imagecolorat($this->image,$x,$y));
					// How transparent until it's actually visible
					// I reackon atleast 10% of 127 before its noticeable, e.g. ~13
					if($col['alpha']>13)
					{
						$this->palette = false;
						break 2;
					}
				}
			}
		}
	}
}
?>
